// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ExcludedPath model.
 */
@Fluent
public final class ExcludedPath implements JsonSerializable<ExcludedPath> {
    /*
     * The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard
     * (/path/*)
     */
    private String path;

    /**
     * Creates an instance of ExcludedPath class.
     */
    public ExcludedPath() {
    }

    /**
     * Get the path property: The path for which the indexing behavior applies to. Index paths typically start with root
     * and end with wildcard (/path/*).
     * 
     * @return the path value.
     */
    public String path() {
        return this.path;
    }

    /**
     * Set the path property: The path for which the indexing behavior applies to. Index paths typically start with root
     * and end with wildcard (/path/*).
     * 
     * @param path the path value to set.
     * @return the ExcludedPath object itself.
     */
    public ExcludedPath withPath(String path) {
        this.path = path;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("path", this.path);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExcludedPath from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExcludedPath if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ExcludedPath.
     */
    public static ExcludedPath fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExcludedPath deserializedExcludedPath = new ExcludedPath();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("path".equals(fieldName)) {
                    deserializedExcludedPath.path = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExcludedPath;
        });
    }
}
