// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The CassandraError model.
 */
@Fluent
public final class CassandraError implements JsonSerializable<CassandraError> {
    /*
     * The code of error that occurred.
     */
    private String code;

    /*
     * The message of the error.
     */
    private String message;

    /*
     * The target resource of the error.
     */
    private String target;

    /*
     * Additional information about the error.
     */
    private String additionalErrorInfo;

    /**
     * Creates an instance of CassandraError class.
     */
    public CassandraError() {
    }

    /**
     * Get the code property: The code of error that occurred.
     * 
     * @return the code value.
     */
    public String code() {
        return this.code;
    }

    /**
     * Set the code property: The code of error that occurred.
     * 
     * @param code the code value to set.
     * @return the CassandraError object itself.
     */
    public CassandraError withCode(String code) {
        this.code = code;
        return this;
    }

    /**
     * Get the message property: The message of the error.
     * 
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Set the message property: The message of the error.
     * 
     * @param message the message value to set.
     * @return the CassandraError object itself.
     */
    public CassandraError withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Get the target property: The target resource of the error.
     * 
     * @return the target value.
     */
    public String target() {
        return this.target;
    }

    /**
     * Set the target property: The target resource of the error.
     * 
     * @param target the target value to set.
     * @return the CassandraError object itself.
     */
    public CassandraError withTarget(String target) {
        this.target = target;
        return this;
    }

    /**
     * Get the additionalErrorInfo property: Additional information about the error.
     * 
     * @return the additionalErrorInfo value.
     */
    public String additionalErrorInfo() {
        return this.additionalErrorInfo;
    }

    /**
     * Set the additionalErrorInfo property: Additional information about the error.
     * 
     * @param additionalErrorInfo the additionalErrorInfo value to set.
     * @return the CassandraError object itself.
     */
    public CassandraError withAdditionalErrorInfo(String additionalErrorInfo) {
        this.additionalErrorInfo = additionalErrorInfo;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("target", this.target);
        jsonWriter.writeStringField("additionalErrorInfo", this.additionalErrorInfo);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CassandraError from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CassandraError if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the CassandraError.
     */
    public static CassandraError fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CassandraError deserializedCassandraError = new CassandraError();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("code".equals(fieldName)) {
                    deserializedCassandraError.code = reader.getString();
                } else if ("message".equals(fieldName)) {
                    deserializedCassandraError.message = reader.getString();
                } else if ("target".equals(fieldName)) {
                    deserializedCassandraError.target = reader.getString();
                } else if ("additionalErrorInfo".equals(fieldName)) {
                    deserializedCassandraError.additionalErrorInfo = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCassandraError;
        });
    }
}
