/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.BackupStorageRedundancy;
import java.io.IOException;

public final class PeriodicModeProperties
implements JsonSerializable<PeriodicModeProperties> {
    private Integer backupIntervalInMinutes;
    private Integer backupRetentionIntervalInHours;
    private BackupStorageRedundancy backupStorageRedundancy;

    public Integer backupIntervalInMinutes() {
        return this.backupIntervalInMinutes;
    }

    public PeriodicModeProperties withBackupIntervalInMinutes(Integer backupIntervalInMinutes) {
        this.backupIntervalInMinutes = backupIntervalInMinutes;
        return this;
    }

    public Integer backupRetentionIntervalInHours() {
        return this.backupRetentionIntervalInHours;
    }

    public PeriodicModeProperties withBackupRetentionIntervalInHours(Integer backupRetentionIntervalInHours) {
        this.backupRetentionIntervalInHours = backupRetentionIntervalInHours;
        return this;
    }

    public BackupStorageRedundancy backupStorageRedundancy() {
        return this.backupStorageRedundancy;
    }

    public PeriodicModeProperties withBackupStorageRedundancy(BackupStorageRedundancy backupStorageRedundancy) {
        this.backupStorageRedundancy = backupStorageRedundancy;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("backupIntervalInMinutes", (Number)this.backupIntervalInMinutes);
        jsonWriter.writeNumberField("backupRetentionIntervalInHours", (Number)this.backupRetentionIntervalInHours);
        jsonWriter.writeStringField("backupStorageRedundancy", this.backupStorageRedundancy == null ? null : this.backupStorageRedundancy.toString());
        return jsonWriter.writeEndObject();
    }

    public static PeriodicModeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PeriodicModeProperties)jsonReader.readObject(reader -> {
            PeriodicModeProperties deserializedPeriodicModeProperties = new PeriodicModeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("backupIntervalInMinutes".equals(fieldName)) {
                    deserializedPeriodicModeProperties.backupIntervalInMinutes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("backupRetentionIntervalInHours".equals(fieldName)) {
                    deserializedPeriodicModeProperties.backupRetentionIntervalInHours = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("backupStorageRedundancy".equals(fieldName)) {
                    deserializedPeriodicModeProperties.backupStorageRedundancy = BackupStorageRedundancy.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPeriodicModeProperties;
        });
    }
}

