/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.BackupPolicy;
import com.azure.resourcemanager.cosmos.models.BackupPolicyMigrationState;
import com.azure.resourcemanager.cosmos.models.BackupPolicyType;
import com.azure.resourcemanager.cosmos.models.PeriodicModeProperties;
import java.io.IOException;

public final class PeriodicModeBackupPolicy
extends BackupPolicy {
    private BackupPolicyType type = BackupPolicyType.PERIODIC;
    private PeriodicModeProperties periodicModeProperties;

    @Override
    public BackupPolicyType type() {
        return this.type;
    }

    public PeriodicModeProperties periodicModeProperties() {
        return this.periodicModeProperties;
    }

    public PeriodicModeBackupPolicy withPeriodicModeProperties(PeriodicModeProperties periodicModeProperties) {
        this.periodicModeProperties = periodicModeProperties;
        return this;
    }

    @Override
    public PeriodicModeBackupPolicy withMigrationState(BackupPolicyMigrationState migrationState) {
        super.withMigrationState(migrationState);
        return this;
    }

    @Override
    public void validate() {
        if (this.periodicModeProperties() != null) {
            this.periodicModeProperties().validate();
        }
        if (this.migrationState() != null) {
            this.migrationState().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("migrationState", (JsonSerializable)this.migrationState());
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("periodicModeProperties", (JsonSerializable)this.periodicModeProperties);
        return jsonWriter.writeEndObject();
    }

    public static PeriodicModeBackupPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (PeriodicModeBackupPolicy)jsonReader.readObject(reader -> {
            PeriodicModeBackupPolicy deserializedPeriodicModeBackupPolicy = new PeriodicModeBackupPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("migrationState".equals(fieldName)) {
                    deserializedPeriodicModeBackupPolicy.withMigrationState(BackupPolicyMigrationState.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedPeriodicModeBackupPolicy.type = BackupPolicyType.fromString(reader.getString());
                    continue;
                }
                if ("periodicModeProperties".equals(fieldName)) {
                    deserializedPeriodicModeBackupPolicy.periodicModeProperties = PeriodicModeProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPeriodicModeBackupPolicy;
        });
    }
}

