/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.Indexes;
import java.io.IOException;
import java.util.List;

public final class IncludedPath
implements JsonSerializable<IncludedPath> {
    private String path;
    private List<Indexes> indexes;

    public String path() {
        return this.path;
    }

    public IncludedPath withPath(String path) {
        this.path = path;
        return this;
    }

    public List<Indexes> indexes() {
        return this.indexes;
    }

    public IncludedPath withIndexes(List<Indexes> indexes) {
        this.indexes = indexes;
        return this;
    }

    public void validate() {
        if (this.indexes() != null) {
            this.indexes().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("path", this.path);
        jsonWriter.writeArrayField("indexes", this.indexes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static IncludedPath fromJson(JsonReader jsonReader) throws IOException {
        return (IncludedPath)jsonReader.readObject(reader -> {
            IncludedPath deserializedIncludedPath = new IncludedPath();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("path".equals(fieldName)) {
                    deserializedIncludedPath.path = reader.getString();
                    continue;
                }
                if ("indexes".equals(fieldName)) {
                    List indexes;
                    deserializedIncludedPath.indexes = indexes = reader.readArray(reader1 -> Indexes.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIncludedPath;
        });
    }
}

