/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.GremlinDatabaseCreateUpdateProperties;
import com.azure.resourcemanager.cosmos.models.ArmResourceProperties;
import com.azure.resourcemanager.cosmos.models.CreateUpdateOptions;
import com.azure.resourcemanager.cosmos.models.GremlinDatabaseResource;
import java.io.IOException;
import java.util.Map;

public final class GremlinDatabaseCreateUpdateParameters
extends ArmResourceProperties {
    private GremlinDatabaseCreateUpdateProperties innerProperties = new GremlinDatabaseCreateUpdateProperties();
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(GremlinDatabaseCreateUpdateParameters.class);

    private GremlinDatabaseCreateUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public GremlinDatabaseCreateUpdateParameters withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public GremlinDatabaseCreateUpdateParameters withTags(Map<String, String> tags) {
        super.withTags((Map)tags);
        return this;
    }

    public GremlinDatabaseResource resource() {
        return this.innerProperties() == null ? null : this.innerProperties().resource();
    }

    public GremlinDatabaseCreateUpdateParameters withResource(GremlinDatabaseResource resource) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GremlinDatabaseCreateUpdateProperties();
        }
        this.innerProperties().withResource(resource);
        return this;
    }

    public CreateUpdateOptions options() {
        return this.innerProperties() == null ? null : this.innerProperties().options();
    }

    public GremlinDatabaseCreateUpdateParameters withOptions(CreateUpdateOptions options) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GremlinDatabaseCreateUpdateProperties();
        }
        this.innerProperties().withOptions(options);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model GremlinDatabaseCreateUpdateParameters"));
        }
        this.innerProperties().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static GremlinDatabaseCreateUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (GremlinDatabaseCreateUpdateParameters)((Object)jsonReader.readObject(reader -> {
            GremlinDatabaseCreateUpdateParameters deserializedGremlinDatabaseCreateUpdateParameters = new GremlinDatabaseCreateUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedGremlinDatabaseCreateUpdateParameters.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedGremlinDatabaseCreateUpdateParameters.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedGremlinDatabaseCreateUpdateParameters.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedGremlinDatabaseCreateUpdateParameters.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedGremlinDatabaseCreateUpdateParameters.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedGremlinDatabaseCreateUpdateParameters.innerProperties = GremlinDatabaseCreateUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGremlinDatabaseCreateUpdateParameters;
        }));
    }
}

