/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.NodeState;
import java.io.IOException;
import java.util.List;

public final class CassandraClusterPublicStatusDataCentersItemNode
implements JsonSerializable<CassandraClusterPublicStatusDataCentersItemNode> {
    private String address;
    private NodeState state;
    private String status;
    private String cassandraProcessStatus;
    private String load;
    private List<String> tokens;
    private Integer size;
    private String hostId;
    private String rack;
    private String timestamp;
    private Long diskUsedKB;
    private Long diskFreeKB;
    private Long memoryUsedKB;
    private Long memoryBuffersAndCachedKB;
    private Long memoryFreeKB;
    private Long memoryTotalKB;
    private Double cpuUsage;

    public String address() {
        return this.address;
    }

    public CassandraClusterPublicStatusDataCentersItemNode withAddress(String address) {
        this.address = address;
        return this;
    }

    public NodeState state() {
        return this.state;
    }

    public CassandraClusterPublicStatusDataCentersItemNode withState(NodeState state) {
        this.state = state;
        return this;
    }

    public String status() {
        return this.status;
    }

    public CassandraClusterPublicStatusDataCentersItemNode withStatus(String status) {
        this.status = status;
        return this;
    }

    public String cassandraProcessStatus() {
        return this.cassandraProcessStatus;
    }

    public CassandraClusterPublicStatusDataCentersItemNode withCassandraProcessStatus(String cassandraProcessStatus) {
        this.cassandraProcessStatus = cassandraProcessStatus;
        return this;
    }

    public String load() {
        return this.load;
    }

    public CassandraClusterPublicStatusDataCentersItemNode withLoad(String load) {
        this.load = load;
        return this;
    }

    public List<String> tokens() {
        return this.tokens;
    }

    public CassandraClusterPublicStatusDataCentersItemNode withTokens(List<String> tokens) {
        this.tokens = tokens;
        return this;
    }

    public Integer size() {
        return this.size;
    }

    public CassandraClusterPublicStatusDataCentersItemNode withSize(Integer size) {
        this.size = size;
        return this;
    }

    public String hostId() {
        return this.hostId;
    }

    public CassandraClusterPublicStatusDataCentersItemNode withHostId(String hostId) {
        this.hostId = hostId;
        return this;
    }

    public String rack() {
        return this.rack;
    }

    public CassandraClusterPublicStatusDataCentersItemNode withRack(String rack) {
        this.rack = rack;
        return this;
    }

    public String timestamp() {
        return this.timestamp;
    }

    public CassandraClusterPublicStatusDataCentersItemNode withTimestamp(String timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public Long diskUsedKB() {
        return this.diskUsedKB;
    }

    public CassandraClusterPublicStatusDataCentersItemNode withDiskUsedKB(Long diskUsedKB) {
        this.diskUsedKB = diskUsedKB;
        return this;
    }

    public Long diskFreeKB() {
        return this.diskFreeKB;
    }

    public CassandraClusterPublicStatusDataCentersItemNode withDiskFreeKB(Long diskFreeKB) {
        this.diskFreeKB = diskFreeKB;
        return this;
    }

    public Long memoryUsedKB() {
        return this.memoryUsedKB;
    }

    public CassandraClusterPublicStatusDataCentersItemNode withMemoryUsedKB(Long memoryUsedKB) {
        this.memoryUsedKB = memoryUsedKB;
        return this;
    }

    public Long memoryBuffersAndCachedKB() {
        return this.memoryBuffersAndCachedKB;
    }

    public CassandraClusterPublicStatusDataCentersItemNode withMemoryBuffersAndCachedKB(Long memoryBuffersAndCachedKB) {
        this.memoryBuffersAndCachedKB = memoryBuffersAndCachedKB;
        return this;
    }

    public Long memoryFreeKB() {
        return this.memoryFreeKB;
    }

    public CassandraClusterPublicStatusDataCentersItemNode withMemoryFreeKB(Long memoryFreeKB) {
        this.memoryFreeKB = memoryFreeKB;
        return this;
    }

    public Long memoryTotalKB() {
        return this.memoryTotalKB;
    }

    public CassandraClusterPublicStatusDataCentersItemNode withMemoryTotalKB(Long memoryTotalKB) {
        this.memoryTotalKB = memoryTotalKB;
        return this;
    }

    public Double cpuUsage() {
        return this.cpuUsage;
    }

    public CassandraClusterPublicStatusDataCentersItemNode withCpuUsage(Double cpuUsage) {
        this.cpuUsage = cpuUsage;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("address", this.address);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeStringField("status", this.status);
        jsonWriter.writeStringField("cassandraProcessStatus", this.cassandraProcessStatus);
        jsonWriter.writeStringField("load", this.load);
        jsonWriter.writeArrayField("tokens", this.tokens, (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("size", (Number)this.size);
        jsonWriter.writeStringField("hostID", this.hostId);
        jsonWriter.writeStringField("rack", this.rack);
        jsonWriter.writeStringField("timestamp", this.timestamp);
        jsonWriter.writeNumberField("diskUsedKB", (Number)this.diskUsedKB);
        jsonWriter.writeNumberField("diskFreeKB", (Number)this.diskFreeKB);
        jsonWriter.writeNumberField("memoryUsedKB", (Number)this.memoryUsedKB);
        jsonWriter.writeNumberField("memoryBuffersAndCachedKB", (Number)this.memoryBuffersAndCachedKB);
        jsonWriter.writeNumberField("memoryFreeKB", (Number)this.memoryFreeKB);
        jsonWriter.writeNumberField("memoryTotalKB", (Number)this.memoryTotalKB);
        jsonWriter.writeNumberField("cpuUsage", (Number)this.cpuUsage);
        return jsonWriter.writeEndObject();
    }

    public static CassandraClusterPublicStatusDataCentersItemNode fromJson(JsonReader jsonReader) throws IOException {
        return (CassandraClusterPublicStatusDataCentersItemNode)jsonReader.readObject(reader -> {
            CassandraClusterPublicStatusDataCentersItemNode deserializedCassandraClusterPublicStatusDataCentersItemNode = new CassandraClusterPublicStatusDataCentersItemNode();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("address".equals(fieldName)) {
                    deserializedCassandraClusterPublicStatusDataCentersItemNode.address = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedCassandraClusterPublicStatusDataCentersItemNode.state = NodeState.fromString(reader.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedCassandraClusterPublicStatusDataCentersItemNode.status = reader.getString();
                    continue;
                }
                if ("cassandraProcessStatus".equals(fieldName)) {
                    deserializedCassandraClusterPublicStatusDataCentersItemNode.cassandraProcessStatus = reader.getString();
                    continue;
                }
                if ("load".equals(fieldName)) {
                    deserializedCassandraClusterPublicStatusDataCentersItemNode.load = reader.getString();
                    continue;
                }
                if ("tokens".equals(fieldName)) {
                    List tokens;
                    deserializedCassandraClusterPublicStatusDataCentersItemNode.tokens = tokens = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("size".equals(fieldName)) {
                    deserializedCassandraClusterPublicStatusDataCentersItemNode.size = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("hostID".equals(fieldName)) {
                    deserializedCassandraClusterPublicStatusDataCentersItemNode.hostId = reader.getString();
                    continue;
                }
                if ("rack".equals(fieldName)) {
                    deserializedCassandraClusterPublicStatusDataCentersItemNode.rack = reader.getString();
                    continue;
                }
                if ("timestamp".equals(fieldName)) {
                    deserializedCassandraClusterPublicStatusDataCentersItemNode.timestamp = reader.getString();
                    continue;
                }
                if ("diskUsedKB".equals(fieldName)) {
                    deserializedCassandraClusterPublicStatusDataCentersItemNode.diskUsedKB = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("diskFreeKB".equals(fieldName)) {
                    deserializedCassandraClusterPublicStatusDataCentersItemNode.diskFreeKB = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("memoryUsedKB".equals(fieldName)) {
                    deserializedCassandraClusterPublicStatusDataCentersItemNode.memoryUsedKB = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("memoryBuffersAndCachedKB".equals(fieldName)) {
                    deserializedCassandraClusterPublicStatusDataCentersItemNode.memoryBuffersAndCachedKB = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("memoryFreeKB".equals(fieldName)) {
                    deserializedCassandraClusterPublicStatusDataCentersItemNode.memoryFreeKB = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("memoryTotalKB".equals(fieldName)) {
                    deserializedCassandraClusterPublicStatusDataCentersItemNode.memoryTotalKB = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("cpuUsage".equals(fieldName)) {
                    deserializedCassandraClusterPublicStatusDataCentersItemNode.cpuUsage = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCassandraClusterPublicStatusDataCentersItemNode;
        });
    }
}

