/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.MetricName;
import com.azure.resourcemanager.cosmos.models.UnitType;
import java.io.IOException;

public class UsageInner
implements JsonSerializable<UsageInner> {
    private UnitType unit;
    private MetricName name;
    private String quotaPeriod;
    private Long limit;
    private Long currentValue;

    public UnitType unit() {
        return this.unit;
    }

    UsageInner withUnit(UnitType unit) {
        this.unit = unit;
        return this;
    }

    public MetricName name() {
        return this.name;
    }

    UsageInner withName(MetricName name) {
        this.name = name;
        return this;
    }

    public String quotaPeriod() {
        return this.quotaPeriod;
    }

    UsageInner withQuotaPeriod(String quotaPeriod) {
        this.quotaPeriod = quotaPeriod;
        return this;
    }

    public Long limit() {
        return this.limit;
    }

    UsageInner withLimit(Long limit) {
        this.limit = limit;
        return this;
    }

    public Long currentValue() {
        return this.currentValue;
    }

    UsageInner withCurrentValue(Long currentValue) {
        this.currentValue = currentValue;
        return this;
    }

    public void validate() {
        if (this.name() != null) {
            this.name().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static UsageInner fromJson(JsonReader jsonReader) throws IOException {
        return (UsageInner)jsonReader.readObject(reader -> {
            UsageInner deserializedUsageInner = new UsageInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("unit".equals(fieldName)) {
                    deserializedUsageInner.unit = UnitType.fromString(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedUsageInner.name = MetricName.fromJson(reader);
                    continue;
                }
                if ("quotaPeriod".equals(fieldName)) {
                    deserializedUsageInner.quotaPeriod = reader.getString();
                    continue;
                }
                if ("limit".equals(fieldName)) {
                    deserializedUsageInner.limit = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("currentValue".equals(fieldName)) {
                    deserializedUsageInner.currentValue = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUsageInner;
        });
    }
}

