/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.TableCreateUpdateProperties;
import com.azure.resourcemanager.cosmos.models.ArmResourceProperties;
import com.azure.resourcemanager.cosmos.models.CreateUpdateOptions;
import com.azure.resourcemanager.cosmos.models.TableResource;
import java.io.IOException;
import java.util.Map;

public final class TableCreateUpdateParameters
extends ArmResourceProperties {
    private TableCreateUpdateProperties innerProperties = new TableCreateUpdateProperties();
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(TableCreateUpdateParameters.class);

    private TableCreateUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public TableCreateUpdateParameters withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public TableCreateUpdateParameters withTags(Map<String, String> tags) {
        super.withTags((Map)tags);
        return this;
    }

    public TableResource resource() {
        return this.innerProperties() == null ? null : this.innerProperties().resource();
    }

    public TableCreateUpdateParameters withResource(TableResource resource) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TableCreateUpdateProperties();
        }
        this.innerProperties().withResource(resource);
        return this;
    }

    public CreateUpdateOptions options() {
        return this.innerProperties() == null ? null : this.innerProperties().options();
    }

    public TableCreateUpdateParameters withOptions(CreateUpdateOptions options) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TableCreateUpdateProperties();
        }
        this.innerProperties().withOptions(options);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model TableCreateUpdateParameters"));
        }
        this.innerProperties().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static TableCreateUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (TableCreateUpdateParameters)((Object)jsonReader.readObject(reader -> {
            TableCreateUpdateParameters deserializedTableCreateUpdateParameters = new TableCreateUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedTableCreateUpdateParameters.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedTableCreateUpdateParameters.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedTableCreateUpdateParameters.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedTableCreateUpdateParameters.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedTableCreateUpdateParameters.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedTableCreateUpdateParameters.innerProperties = TableCreateUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTableCreateUpdateParameters;
        }));
    }
}

