/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.KeyWrapMetadata;
import java.io.IOException;

public class ClientEncryptionKeyResource
implements JsonSerializable<ClientEncryptionKeyResource> {
    private String id;
    private String encryptionAlgorithm;
    private byte[] wrappedDataEncryptionKey;
    private KeyWrapMetadata keyWrapMetadata;

    public String id() {
        return this.id;
    }

    public ClientEncryptionKeyResource withId(String id) {
        this.id = id;
        return this;
    }

    public String encryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public ClientEncryptionKeyResource withEncryptionAlgorithm(String encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
        return this;
    }

    public byte[] wrappedDataEncryptionKey() {
        return CoreUtils.clone((byte[])this.wrappedDataEncryptionKey);
    }

    public ClientEncryptionKeyResource withWrappedDataEncryptionKey(byte[] wrappedDataEncryptionKey) {
        this.wrappedDataEncryptionKey = CoreUtils.clone((byte[])wrappedDataEncryptionKey);
        return this;
    }

    public KeyWrapMetadata keyWrapMetadata() {
        return this.keyWrapMetadata;
    }

    public ClientEncryptionKeyResource withKeyWrapMetadata(KeyWrapMetadata keyWrapMetadata) {
        this.keyWrapMetadata = keyWrapMetadata;
        return this;
    }

    public void validate() {
        if (this.keyWrapMetadata() != null) {
            this.keyWrapMetadata().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("encryptionAlgorithm", this.encryptionAlgorithm);
        jsonWriter.writeBinaryField("wrappedDataEncryptionKey", this.wrappedDataEncryptionKey);
        jsonWriter.writeJsonField("keyWrapMetadata", (JsonSerializable)this.keyWrapMetadata);
        return jsonWriter.writeEndObject();
    }

    public static ClientEncryptionKeyResource fromJson(JsonReader jsonReader) throws IOException {
        return (ClientEncryptionKeyResource)jsonReader.readObject(reader -> {
            ClientEncryptionKeyResource deserializedClientEncryptionKeyResource = new ClientEncryptionKeyResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedClientEncryptionKeyResource.id = reader.getString();
                    continue;
                }
                if ("encryptionAlgorithm".equals(fieldName)) {
                    deserializedClientEncryptionKeyResource.encryptionAlgorithm = reader.getString();
                    continue;
                }
                if ("wrappedDataEncryptionKey".equals(fieldName)) {
                    deserializedClientEncryptionKeyResource.wrappedDataEncryptionKey = reader.getBinary();
                    continue;
                }
                if ("keyWrapMetadata".equals(fieldName)) {
                    deserializedClientEncryptionKeyResource.keyWrapMetadata = KeyWrapMetadata.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClientEncryptionKeyResource;
        });
    }
}

