// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Cosmos DB Vector Embedding Policy.
 */
@Fluent
public final class VectorEmbeddingPolicy implements JsonSerializable<VectorEmbeddingPolicy> {
    /*
     * List of vector embeddings
     */
    private List<VectorEmbedding> vectorEmbeddings;

    /**
     * Creates an instance of VectorEmbeddingPolicy class.
     */
    public VectorEmbeddingPolicy() {
    }

    /**
     * Get the vectorEmbeddings property: List of vector embeddings.
     * 
     * @return the vectorEmbeddings value.
     */
    public List<VectorEmbedding> vectorEmbeddings() {
        return this.vectorEmbeddings;
    }

    /**
     * Set the vectorEmbeddings property: List of vector embeddings.
     * 
     * @param vectorEmbeddings the vectorEmbeddings value to set.
     * @return the VectorEmbeddingPolicy object itself.
     */
    public VectorEmbeddingPolicy withVectorEmbeddings(List<VectorEmbedding> vectorEmbeddings) {
        this.vectorEmbeddings = vectorEmbeddings;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (vectorEmbeddings() != null) {
            vectorEmbeddings().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("vectorEmbeddings", this.vectorEmbeddings,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VectorEmbeddingPolicy from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VectorEmbeddingPolicy if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VectorEmbeddingPolicy.
     */
    public static VectorEmbeddingPolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VectorEmbeddingPolicy deserializedVectorEmbeddingPolicy = new VectorEmbeddingPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("vectorEmbeddings".equals(fieldName)) {
                    List<VectorEmbedding> vectorEmbeddings
                        = reader.readArray(reader1 -> VectorEmbedding.fromJson(reader1));
                    deserializedVectorEmbeddingPolicy.vectorEmbeddings = vectorEmbeddings;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVectorEmbeddingPolicy;
        });
    }
}
