// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.RestorableMongodbResourcesGetResultInner;
import java.io.IOException;
import java.util.List;

/**
 * The List operation response, that contains the restorable MongoDB resources.
 */
@Immutable
public final class RestorableMongodbResourcesListResult
    implements JsonSerializable<RestorableMongodbResourcesListResult> {
    /*
     * List of restorable MongoDB resources, including the database and collection names.
     */
    private List<RestorableMongodbResourcesGetResultInner> value;

    /**
     * Creates an instance of RestorableMongodbResourcesListResult class.
     */
    public RestorableMongodbResourcesListResult() {
    }

    /**
     * Get the value property: List of restorable MongoDB resources, including the database and collection names.
     * 
     * @return the value value.
     */
    public List<RestorableMongodbResourcesGetResultInner> value() {
        return this.value;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RestorableMongodbResourcesListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RestorableMongodbResourcesListResult if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RestorableMongodbResourcesListResult.
     */
    public static RestorableMongodbResourcesListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RestorableMongodbResourcesListResult deserializedRestorableMongodbResourcesListResult
                = new RestorableMongodbResourcesListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<RestorableMongodbResourcesGetResultInner> value
                        = reader.readArray(reader1 -> RestorableMongodbResourcesGetResultInner.fromJson(reader1));
                    deserializedRestorableMongodbResourcesListResult.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRestorableMongodbResourcesListResult;
        });
    }
}
