// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.DataCenterResourceInner;
import java.io.IOException;
import java.util.List;

/**
 * List of managed Cassandra data centers and their properties.
 */
@Immutable
public final class ListDataCenters implements JsonSerializable<ListDataCenters> {
    /*
     * Container for array of data centers.
     */
    private List<DataCenterResourceInner> value;

    /**
     * Creates an instance of ListDataCenters class.
     */
    public ListDataCenters() {
    }

    /**
     * Get the value property: Container for array of data centers.
     * 
     * @return the value value.
     */
    public List<DataCenterResourceInner> value() {
        return this.value;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ListDataCenters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ListDataCenters if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ListDataCenters.
     */
    public static ListDataCenters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ListDataCenters deserializedListDataCenters = new ListDataCenters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<DataCenterResourceInner> value
                        = reader.readArray(reader1 -> DataCenterResourceInner.fromJson(reader1));
                    deserializedListDataCenters.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedListDataCenters;
        });
    }
}
