/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.ConflictResolutionPolicy;
import com.azure.resourcemanager.cosmos.models.ContainerPartitionKey;
import com.azure.resourcemanager.cosmos.models.CreateMode;
import com.azure.resourcemanager.cosmos.models.GremlinGraphResource;
import com.azure.resourcemanager.cosmos.models.IndexingPolicy;
import com.azure.resourcemanager.cosmos.models.ResourceRestoreParameters;
import com.azure.resourcemanager.cosmos.models.UniqueKeyPolicy;
import java.io.IOException;

public final class GremlinGraphGetPropertiesResource
extends GremlinGraphResource {
    private String rid;
    private Float ts;
    private String etag;
    private static final ClientLogger LOGGER = new ClientLogger(GremlinGraphGetPropertiesResource.class);

    public String rid() {
        return this.rid;
    }

    public Float ts() {
        return this.ts;
    }

    public String etag() {
        return this.etag;
    }

    @Override
    public GremlinGraphGetPropertiesResource withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public GremlinGraphGetPropertiesResource withIndexingPolicy(IndexingPolicy indexingPolicy) {
        super.withIndexingPolicy(indexingPolicy);
        return this;
    }

    @Override
    public GremlinGraphGetPropertiesResource withPartitionKey(ContainerPartitionKey partitionKey) {
        super.withPartitionKey(partitionKey);
        return this;
    }

    @Override
    public GremlinGraphGetPropertiesResource withDefaultTtl(Integer defaultTtl) {
        super.withDefaultTtl(defaultTtl);
        return this;
    }

    @Override
    public GremlinGraphGetPropertiesResource withUniqueKeyPolicy(UniqueKeyPolicy uniqueKeyPolicy) {
        super.withUniqueKeyPolicy(uniqueKeyPolicy);
        return this;
    }

    @Override
    public GremlinGraphGetPropertiesResource withConflictResolutionPolicy(ConflictResolutionPolicy conflictResolutionPolicy) {
        super.withConflictResolutionPolicy(conflictResolutionPolicy);
        return this;
    }

    @Override
    public GremlinGraphGetPropertiesResource withAnalyticalStorageTtl(Long analyticalStorageTtl) {
        super.withAnalyticalStorageTtl(analyticalStorageTtl);
        return this;
    }

    @Override
    public GremlinGraphGetPropertiesResource withRestoreParameters(ResourceRestoreParameters restoreParameters) {
        super.withRestoreParameters(restoreParameters);
        return this;
    }

    @Override
    public GremlinGraphGetPropertiesResource withCreateMode(CreateMode createMode) {
        super.withCreateMode(createMode);
        return this;
    }

    @Override
    public void validate() {
        if (this.id() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property id in model GremlinGraphGetPropertiesResource"));
        }
        if (this.indexingPolicy() != null) {
            this.indexingPolicy().validate();
        }
        if (this.partitionKey() != null) {
            this.partitionKey().validate();
        }
        if (this.uniqueKeyPolicy() != null) {
            this.uniqueKeyPolicy().validate();
        }
        if (this.conflictResolutionPolicy() != null) {
            this.conflictResolutionPolicy().validate();
        }
        if (this.restoreParameters() != null) {
            this.restoreParameters().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("indexingPolicy", (JsonSerializable)this.indexingPolicy());
        jsonWriter.writeJsonField("partitionKey", (JsonSerializable)this.partitionKey());
        jsonWriter.writeNumberField("defaultTtl", (Number)this.defaultTtl());
        jsonWriter.writeJsonField("uniqueKeyPolicy", (JsonSerializable)this.uniqueKeyPolicy());
        jsonWriter.writeJsonField("conflictResolutionPolicy", (JsonSerializable)this.conflictResolutionPolicy());
        jsonWriter.writeNumberField("analyticalStorageTtl", (Number)this.analyticalStorageTtl());
        jsonWriter.writeJsonField("restoreParameters", (JsonSerializable)this.restoreParameters());
        jsonWriter.writeStringField("createMode", this.createMode() == null ? null : this.createMode().toString());
        return jsonWriter.writeEndObject();
    }

    public static GremlinGraphGetPropertiesResource fromJson(JsonReader jsonReader) throws IOException {
        return (GremlinGraphGetPropertiesResource)jsonReader.readObject(reader -> {
            GremlinGraphGetPropertiesResource deserializedGremlinGraphGetPropertiesResource = new GremlinGraphGetPropertiesResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedGremlinGraphGetPropertiesResource.withId(reader.getString());
                    continue;
                }
                if ("indexingPolicy".equals(fieldName)) {
                    deserializedGremlinGraphGetPropertiesResource.withIndexingPolicy(IndexingPolicy.fromJson(reader));
                    continue;
                }
                if ("partitionKey".equals(fieldName)) {
                    deserializedGremlinGraphGetPropertiesResource.withPartitionKey(ContainerPartitionKey.fromJson(reader));
                    continue;
                }
                if ("defaultTtl".equals(fieldName)) {
                    deserializedGremlinGraphGetPropertiesResource.withDefaultTtl((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("uniqueKeyPolicy".equals(fieldName)) {
                    deserializedGremlinGraphGetPropertiesResource.withUniqueKeyPolicy(UniqueKeyPolicy.fromJson(reader));
                    continue;
                }
                if ("conflictResolutionPolicy".equals(fieldName)) {
                    deserializedGremlinGraphGetPropertiesResource.withConflictResolutionPolicy(ConflictResolutionPolicy.fromJson(reader));
                    continue;
                }
                if ("analyticalStorageTtl".equals(fieldName)) {
                    deserializedGremlinGraphGetPropertiesResource.withAnalyticalStorageTtl((Long)reader.getNullable(JsonReader::getLong));
                    continue;
                }
                if ("restoreParameters".equals(fieldName)) {
                    deserializedGremlinGraphGetPropertiesResource.withRestoreParameters(ResourceRestoreParameters.fromJson(reader));
                    continue;
                }
                if ("createMode".equals(fieldName)) {
                    deserializedGremlinGraphGetPropertiesResource.withCreateMode(CreateMode.fromString(reader.getString()));
                    continue;
                }
                if ("_rid".equals(fieldName)) {
                    deserializedGremlinGraphGetPropertiesResource.rid = reader.getString();
                    continue;
                }
                if ("_ts".equals(fieldName)) {
                    deserializedGremlinGraphGetPropertiesResource.ts = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("_etag".equals(fieldName)) {
                    deserializedGremlinGraphGetPropertiesResource.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGremlinGraphGetPropertiesResource;
        });
    }
}

