/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.MetricAvailability;
import com.azure.resourcemanager.cosmos.models.MetricName;
import com.azure.resourcemanager.cosmos.models.PrimaryAggregationType;
import com.azure.resourcemanager.cosmos.models.UnitType;
import java.io.IOException;
import java.util.List;

public final class MetricDefinitionInner
implements JsonSerializable<MetricDefinitionInner> {
    private List<MetricAvailability> metricAvailabilities;
    private PrimaryAggregationType primaryAggregationType;
    private UnitType unit;
    private String resourceUri;
    private MetricName name;

    public List<MetricAvailability> metricAvailabilities() {
        return this.metricAvailabilities;
    }

    public PrimaryAggregationType primaryAggregationType() {
        return this.primaryAggregationType;
    }

    public UnitType unit() {
        return this.unit;
    }

    public String resourceUri() {
        return this.resourceUri;
    }

    public MetricName name() {
        return this.name;
    }

    public void validate() {
        if (this.metricAvailabilities() != null) {
            this.metricAvailabilities().forEach(e -> e.validate());
        }
        if (this.name() != null) {
            this.name().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static MetricDefinitionInner fromJson(JsonReader jsonReader) throws IOException {
        return (MetricDefinitionInner)jsonReader.readObject(reader -> {
            MetricDefinitionInner deserializedMetricDefinitionInner = new MetricDefinitionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("metricAvailabilities".equals(fieldName)) {
                    List metricAvailabilities;
                    deserializedMetricDefinitionInner.metricAvailabilities = metricAvailabilities = reader.readArray(reader1 -> MetricAvailability.fromJson(reader1));
                    continue;
                }
                if ("primaryAggregationType".equals(fieldName)) {
                    deserializedMetricDefinitionInner.primaryAggregationType = PrimaryAggregationType.fromString(reader.getString());
                    continue;
                }
                if ("unit".equals(fieldName)) {
                    deserializedMetricDefinitionInner.unit = UnitType.fromString(reader.getString());
                    continue;
                }
                if ("resourceUri".equals(fieldName)) {
                    deserializedMetricDefinitionInner.resourceUri = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMetricDefinitionInner.name = MetricName.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMetricDefinitionInner;
        });
    }
}

