/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.CassandraTableResource;
import com.azure.resourcemanager.cosmos.models.CreateUpdateOptions;
import java.io.IOException;

public final class CassandraTableCreateUpdateProperties
implements JsonSerializable<CassandraTableCreateUpdateProperties> {
    private CassandraTableResource resource;
    private CreateUpdateOptions options;
    private static final ClientLogger LOGGER = new ClientLogger(CassandraTableCreateUpdateProperties.class);

    public CassandraTableResource resource() {
        return this.resource;
    }

    public CassandraTableCreateUpdateProperties withResource(CassandraTableResource resource) {
        this.resource = resource;
        return this;
    }

    public CreateUpdateOptions options() {
        return this.options;
    }

    public CassandraTableCreateUpdateProperties withOptions(CreateUpdateOptions options) {
        this.options = options;
        return this;
    }

    public void validate() {
        if (this.resource() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property resource in model CassandraTableCreateUpdateProperties"));
        }
        this.resource().validate();
        if (this.options() != null) {
            this.options().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("resource", (JsonSerializable)this.resource);
        jsonWriter.writeJsonField("options", (JsonSerializable)this.options);
        return jsonWriter.writeEndObject();
    }

    public static CassandraTableCreateUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CassandraTableCreateUpdateProperties)jsonReader.readObject(reader -> {
            CassandraTableCreateUpdateProperties deserializedCassandraTableCreateUpdateProperties = new CassandraTableCreateUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resource".equals(fieldName)) {
                    deserializedCassandraTableCreateUpdateProperties.resource = CassandraTableResource.fromJson(reader);
                    continue;
                }
                if ("options".equals(fieldName)) {
                    deserializedCassandraTableCreateUpdateProperties.options = CreateUpdateOptions.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCassandraTableCreateUpdateProperties;
        });
    }
}

