// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Virtual Network ACL Rule object.
 */
@Fluent
public final class VirtualNetworkRule implements JsonSerializable<VirtualNetworkRule> {
    /*
     * Resource ID of a subnet, for example:
     * /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{
     * virtualNetworkName}/subnets/{subnetName}.
     */
    private String id;

    /*
     * Create firewall rule before the virtual network has vnet service endpoint enabled.
     */
    private Boolean ignoreMissingVNetServiceEndpoint;

    /**
     * Creates an instance of VirtualNetworkRule class.
     */
    public VirtualNetworkRule() {
    }

    /**
     * Get the id property: Resource ID of a subnet, for example:
     * /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Resource ID of a subnet, for example:
     * /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
     * 
     * @param id the id value to set.
     * @return the VirtualNetworkRule object itself.
     */
    public VirtualNetworkRule withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the ignoreMissingVNetServiceEndpoint property: Create firewall rule before the virtual network has vnet
     * service endpoint enabled.
     * 
     * @return the ignoreMissingVNetServiceEndpoint value.
     */
    public Boolean ignoreMissingVNetServiceEndpoint() {
        return this.ignoreMissingVNetServiceEndpoint;
    }

    /**
     * Set the ignoreMissingVNetServiceEndpoint property: Create firewall rule before the virtual network has vnet
     * service endpoint enabled.
     * 
     * @param ignoreMissingVNetServiceEndpoint the ignoreMissingVNetServiceEndpoint value to set.
     * @return the VirtualNetworkRule object itself.
     */
    public VirtualNetworkRule withIgnoreMissingVNetServiceEndpoint(Boolean ignoreMissingVNetServiceEndpoint) {
        this.ignoreMissingVNetServiceEndpoint = ignoreMissingVNetServiceEndpoint;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeBooleanField("ignoreMissingVNetServiceEndpoint", this.ignoreMissingVNetServiceEndpoint);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualNetworkRule from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualNetworkRule if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualNetworkRule.
     */
    public static VirtualNetworkRule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualNetworkRule deserializedVirtualNetworkRule = new VirtualNetworkRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedVirtualNetworkRule.id = reader.getString();
                } else if ("ignoreMissingVNetServiceEndpoint".equals(fieldName)) {
                    deserializedVirtualNetworkRule.ignoreMissingVNetServiceEndpoint
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualNetworkRule;
        });
    }
}
