// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.RestorableSqlContainerPropertiesResource;
import java.io.IOException;

/**
 * An Azure Cosmos DB SQL container event.
 */
@Fluent
public final class RestorableSqlContainerGetResultInner
    implements JsonSerializable<RestorableSqlContainerGetResultInner> {
    /*
     * The properties of a SQL container event.
     */
    private RestorableSqlContainerProperties innerProperties;

    /*
     * The unique resource Identifier of the ARM resource.
     */
    private String id;

    /*
     * The name of the ARM resource.
     */
    private String name;

    /*
     * The type of Azure resource.
     */
    private String type;

    /**
     * Creates an instance of RestorableSqlContainerGetResultInner class.
     */
    public RestorableSqlContainerGetResultInner() {
    }

    /**
     * Get the innerProperties property: The properties of a SQL container event.
     * 
     * @return the innerProperties value.
     */
    private RestorableSqlContainerProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: The unique resource Identifier of the ARM resource.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the ARM resource.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of Azure resource.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the resource property: The resource of an Azure Cosmos DB SQL container event.
     * 
     * @return the resource value.
     */
    public RestorableSqlContainerPropertiesResource resource() {
        return this.innerProperties() == null ? null : this.innerProperties().resource();
    }

    /**
     * Set the resource property: The resource of an Azure Cosmos DB SQL container event.
     * 
     * @param resource the resource value to set.
     * @return the RestorableSqlContainerGetResultInner object itself.
     */
    public RestorableSqlContainerGetResultInner withResource(RestorableSqlContainerPropertiesResource resource) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RestorableSqlContainerProperties();
        }
        this.innerProperties().withResource(resource);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RestorableSqlContainerGetResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RestorableSqlContainerGetResultInner if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RestorableSqlContainerGetResultInner.
     */
    public static RestorableSqlContainerGetResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RestorableSqlContainerGetResultInner deserializedRestorableSqlContainerGetResultInner
                = new RestorableSqlContainerGetResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedRestorableSqlContainerGetResultInner.innerProperties
                        = RestorableSqlContainerProperties.fromJson(reader);
                } else if ("id".equals(fieldName)) {
                    deserializedRestorableSqlContainerGetResultInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedRestorableSqlContainerGetResultInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedRestorableSqlContainerGetResultInner.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRestorableSqlContainerGetResultInner;
        });
    }
}
