/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.MetricValue;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class PercentileMetricValue
extends MetricValue {
    private Double p10;
    private Double p25;
    private Double p50;
    private Double p75;
    private Double p90;
    private Double p95;
    private Double p99;
    private Double total;
    private OffsetDateTime timestamp;
    private Double minimum;
    private Double maximum;
    private Double average;
    private Integer count;

    public Double p10() {
        return this.p10;
    }

    public Double p25() {
        return this.p25;
    }

    public Double p50() {
        return this.p50;
    }

    public Double p75() {
        return this.p75;
    }

    public Double p90() {
        return this.p90;
    }

    public Double p95() {
        return this.p95;
    }

    public Double p99() {
        return this.p99;
    }

    @Override
    public Double total() {
        return this.total;
    }

    @Override
    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    @Override
    public Double minimum() {
        return this.minimum;
    }

    @Override
    public Double maximum() {
        return this.maximum;
    }

    @Override
    public Double average() {
        return this.average;
    }

    @Override
    public Integer count() {
        return this.count;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static PercentileMetricValue fromJson(JsonReader jsonReader) throws IOException {
        return (PercentileMetricValue)jsonReader.readObject(reader -> {
            PercentileMetricValue deserializedPercentileMetricValue = new PercentileMetricValue();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("_count".equals(fieldName)) {
                    deserializedPercentileMetricValue.count = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("average".equals(fieldName)) {
                    deserializedPercentileMetricValue.average = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("maximum".equals(fieldName)) {
                    deserializedPercentileMetricValue.maximum = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("minimum".equals(fieldName)) {
                    deserializedPercentileMetricValue.minimum = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("timestamp".equals(fieldName)) {
                    deserializedPercentileMetricValue.timestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("total".equals(fieldName)) {
                    deserializedPercentileMetricValue.total = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("P10".equals(fieldName)) {
                    deserializedPercentileMetricValue.p10 = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("P25".equals(fieldName)) {
                    deserializedPercentileMetricValue.p25 = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("P50".equals(fieldName)) {
                    deserializedPercentileMetricValue.p50 = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("P75".equals(fieldName)) {
                    deserializedPercentileMetricValue.p75 = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("P90".equals(fieldName)) {
                    deserializedPercentileMetricValue.p90 = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("P95".equals(fieldName)) {
                    deserializedPercentileMetricValue.p95 = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("P99".equals(fieldName)) {
                    deserializedPercentileMetricValue.p99 = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPercentileMetricValue;
        });
    }
}

