/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.KeyKind;
import java.io.IOException;

public final class DatabaseAccountRegenerateKeyParameters
implements JsonSerializable<DatabaseAccountRegenerateKeyParameters> {
    private KeyKind keyKind;
    private static final ClientLogger LOGGER = new ClientLogger(DatabaseAccountRegenerateKeyParameters.class);

    public KeyKind keyKind() {
        return this.keyKind;
    }

    public DatabaseAccountRegenerateKeyParameters withKeyKind(KeyKind keyKind) {
        this.keyKind = keyKind;
        return this;
    }

    public void validate() {
        if (this.keyKind() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property keyKind in model DatabaseAccountRegenerateKeyParameters"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyKind", this.keyKind == null ? null : this.keyKind.toString());
        return jsonWriter.writeEndObject();
    }

    public static DatabaseAccountRegenerateKeyParameters fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseAccountRegenerateKeyParameters)jsonReader.readObject(reader -> {
            DatabaseAccountRegenerateKeyParameters deserializedDatabaseAccountRegenerateKeyParameters = new DatabaseAccountRegenerateKeyParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keyKind".equals(fieldName)) {
                    deserializedDatabaseAccountRegenerateKeyParameters.keyKind = KeyKind.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseAccountRegenerateKeyParameters;
        });
    }
}

