/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.ClientEncryptionKeyResource;
import com.azure.resourcemanager.cosmos.models.KeyWrapMetadata;
import java.io.IOException;

public final class ClientEncryptionKeyGetPropertiesResource
extends ClientEncryptionKeyResource {
    private String rid;
    private Float ts;
    private String etag;

    public String rid() {
        return this.rid;
    }

    public Float ts() {
        return this.ts;
    }

    public String etag() {
        return this.etag;
    }

    @Override
    public ClientEncryptionKeyGetPropertiesResource withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public ClientEncryptionKeyGetPropertiesResource withEncryptionAlgorithm(String encryptionAlgorithm) {
        super.withEncryptionAlgorithm(encryptionAlgorithm);
        return this;
    }

    @Override
    public ClientEncryptionKeyGetPropertiesResource withWrappedDataEncryptionKey(byte[] wrappedDataEncryptionKey) {
        super.withWrappedDataEncryptionKey(wrappedDataEncryptionKey);
        return this;
    }

    @Override
    public ClientEncryptionKeyGetPropertiesResource withKeyWrapMetadata(KeyWrapMetadata keyWrapMetadata) {
        super.withKeyWrapMetadata(keyWrapMetadata);
        return this;
    }

    @Override
    public void validate() {
        if (this.keyWrapMetadata() != null) {
            this.keyWrapMetadata().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("encryptionAlgorithm", this.encryptionAlgorithm());
        jsonWriter.writeBinaryField("wrappedDataEncryptionKey", this.wrappedDataEncryptionKey());
        jsonWriter.writeJsonField("keyWrapMetadata", (JsonSerializable)this.keyWrapMetadata());
        return jsonWriter.writeEndObject();
    }

    public static ClientEncryptionKeyGetPropertiesResource fromJson(JsonReader jsonReader) throws IOException {
        return (ClientEncryptionKeyGetPropertiesResource)jsonReader.readObject(reader -> {
            ClientEncryptionKeyGetPropertiesResource deserializedClientEncryptionKeyGetPropertiesResource = new ClientEncryptionKeyGetPropertiesResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedClientEncryptionKeyGetPropertiesResource.withId(reader.getString());
                    continue;
                }
                if ("encryptionAlgorithm".equals(fieldName)) {
                    deserializedClientEncryptionKeyGetPropertiesResource.withEncryptionAlgorithm(reader.getString());
                    continue;
                }
                if ("wrappedDataEncryptionKey".equals(fieldName)) {
                    deserializedClientEncryptionKeyGetPropertiesResource.withWrappedDataEncryptionKey(reader.getBinary());
                    continue;
                }
                if ("keyWrapMetadata".equals(fieldName)) {
                    deserializedClientEncryptionKeyGetPropertiesResource.withKeyWrapMetadata(KeyWrapMetadata.fromJson(reader));
                    continue;
                }
                if ("_rid".equals(fieldName)) {
                    deserializedClientEncryptionKeyGetPropertiesResource.rid = reader.getString();
                    continue;
                }
                if ("_ts".equals(fieldName)) {
                    deserializedClientEncryptionKeyGetPropertiesResource.ts = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("_etag".equals(fieldName)) {
                    deserializedClientEncryptionKeyGetPropertiesResource.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClientEncryptionKeyGetPropertiesResource;
        });
    }
}

