/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.Role;
import java.io.IOException;
import java.util.List;

public final class MongoUserDefinitionResource
implements JsonSerializable<MongoUserDefinitionResource> {
    private String username;
    private String password;
    private String databaseName;
    private String customData;
    private List<Role> roles;
    private String mechanisms;

    public String username() {
        return this.username;
    }

    public MongoUserDefinitionResource withUsername(String username) {
        this.username = username;
        return this;
    }

    public String password() {
        return this.password;
    }

    public MongoUserDefinitionResource withPassword(String password) {
        this.password = password;
        return this;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public MongoUserDefinitionResource withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public String customData() {
        return this.customData;
    }

    public MongoUserDefinitionResource withCustomData(String customData) {
        this.customData = customData;
        return this;
    }

    public List<Role> roles() {
        return this.roles;
    }

    public MongoUserDefinitionResource withRoles(List<Role> roles) {
        this.roles = roles;
        return this;
    }

    public String mechanisms() {
        return this.mechanisms;
    }

    public MongoUserDefinitionResource withMechanisms(String mechanisms) {
        this.mechanisms = mechanisms;
        return this;
    }

    public void validate() {
        if (this.roles() != null) {
            this.roles().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("userName", this.username);
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeStringField("databaseName", this.databaseName);
        jsonWriter.writeStringField("customData", this.customData);
        jsonWriter.writeArrayField("roles", this.roles, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("mechanisms", this.mechanisms);
        return jsonWriter.writeEndObject();
    }

    public static MongoUserDefinitionResource fromJson(JsonReader jsonReader) throws IOException {
        return (MongoUserDefinitionResource)jsonReader.readObject(reader -> {
            MongoUserDefinitionResource deserializedMongoUserDefinitionResource = new MongoUserDefinitionResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("userName".equals(fieldName)) {
                    deserializedMongoUserDefinitionResource.username = reader.getString();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedMongoUserDefinitionResource.password = reader.getString();
                    continue;
                }
                if ("databaseName".equals(fieldName)) {
                    deserializedMongoUserDefinitionResource.databaseName = reader.getString();
                    continue;
                }
                if ("customData".equals(fieldName)) {
                    deserializedMongoUserDefinitionResource.customData = reader.getString();
                    continue;
                }
                if ("roles".equals(fieldName)) {
                    List roles;
                    deserializedMongoUserDefinitionResource.roles = roles = reader.readArray(reader1 -> Role.fromJson(reader1));
                    continue;
                }
                if ("mechanisms".equals(fieldName)) {
                    deserializedMongoUserDefinitionResource.mechanisms = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMongoUserDefinitionResource;
        });
    }
}

