/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.BackupStorageRedundancy;
import com.azure.resourcemanager.cosmos.models.Status;
import java.io.IOException;
import java.util.List;

public final class LocationProperties
implements JsonSerializable<LocationProperties> {
    private Boolean supportsAvailabilityZone;
    private Boolean isResidencyRestricted;
    private List<BackupStorageRedundancy> backupStorageRedundancies;
    private Boolean isSubscriptionRegionAccessAllowedForRegular;
    private Boolean isSubscriptionRegionAccessAllowedForAz;
    private Status status;

    public Boolean supportsAvailabilityZone() {
        return this.supportsAvailabilityZone;
    }

    public Boolean isResidencyRestricted() {
        return this.isResidencyRestricted;
    }

    public List<BackupStorageRedundancy> backupStorageRedundancies() {
        return this.backupStorageRedundancies;
    }

    public Boolean isSubscriptionRegionAccessAllowedForRegular() {
        return this.isSubscriptionRegionAccessAllowedForRegular;
    }

    public Boolean isSubscriptionRegionAccessAllowedForAz() {
        return this.isSubscriptionRegionAccessAllowedForAz;
    }

    public Status status() {
        return this.status;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static LocationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (LocationProperties)jsonReader.readObject(reader -> {
            LocationProperties deserializedLocationProperties = new LocationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("supportsAvailabilityZone".equals(fieldName)) {
                    deserializedLocationProperties.supportsAvailabilityZone = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isResidencyRestricted".equals(fieldName)) {
                    deserializedLocationProperties.isResidencyRestricted = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("backupStorageRedundancies".equals(fieldName)) {
                    List backupStorageRedundancies;
                    deserializedLocationProperties.backupStorageRedundancies = backupStorageRedundancies = reader.readArray(reader1 -> BackupStorageRedundancy.fromString(reader1.getString()));
                    continue;
                }
                if ("isSubscriptionRegionAccessAllowedForRegular".equals(fieldName)) {
                    deserializedLocationProperties.isSubscriptionRegionAccessAllowedForRegular = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isSubscriptionRegionAccessAllowedForAz".equals(fieldName)) {
                    deserializedLocationProperties.isSubscriptionRegionAccessAllowedForAz = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedLocationProperties.status = Status.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLocationProperties;
        });
    }
}

