// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.ServiceResourceInner;
import java.io.IOException;
import java.util.List;

/**
 * The List operation response, that contains the Service Resource and their properties.
 */
@Immutable
public final class ServiceResourceListResult implements JsonSerializable<ServiceResourceListResult> {
    /*
     * List of Service Resource and their properties.
     */
    private List<ServiceResourceInner> value;

    /**
     * Creates an instance of ServiceResourceListResult class.
     */
    public ServiceResourceListResult() {
    }

    /**
     * Get the value property: List of Service Resource and their properties.
     * 
     * @return the value value.
     */
    public List<ServiceResourceInner> value() {
        return this.value;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServiceResourceListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServiceResourceListResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ServiceResourceListResult.
     */
    public static ServiceResourceListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServiceResourceListResult deserializedServiceResourceListResult = new ServiceResourceListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ServiceResourceInner> value
                        = reader.readArray(reader1 -> ServiceResourceInner.fromJson(reader1));
                    deserializedServiceResourceListResult.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServiceResourceListResult;
        });
    }
}
