// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Identity for the resource.
 */
@Fluent
public final class ManagedCassandraManagedServiceIdentity
    implements JsonSerializable<ManagedCassandraManagedServiceIdentity> {
    /*
     * The object id of the identity resource.
     */
    private String principalId;

    /*
     * The tenant id of the resource.
     */
    private String tenantId;

    /*
     * The type of the resource.
     */
    private ManagedCassandraResourceIdentityType type;

    /**
     * Creates an instance of ManagedCassandraManagedServiceIdentity class.
     */
    public ManagedCassandraManagedServiceIdentity() {
    }

    /**
     * Get the principalId property: The object id of the identity resource.
     * 
     * @return the principalId value.
     */
    public String principalId() {
        return this.principalId;
    }

    /**
     * Get the tenantId property: The tenant id of the resource.
     * 
     * @return the tenantId value.
     */
    public String tenantId() {
        return this.tenantId;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    public ManagedCassandraResourceIdentityType type() {
        return this.type;
    }

    /**
     * Set the type property: The type of the resource.
     * 
     * @param type the type value to set.
     * @return the ManagedCassandraManagedServiceIdentity object itself.
     */
    public ManagedCassandraManagedServiceIdentity withType(ManagedCassandraResourceIdentityType type) {
        this.type = type;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedCassandraManagedServiceIdentity from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedCassandraManagedServiceIdentity if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedCassandraManagedServiceIdentity.
     */
    public static ManagedCassandraManagedServiceIdentity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedCassandraManagedServiceIdentity deserializedManagedCassandraManagedServiceIdentity
                = new ManagedCassandraManagedServiceIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("principalId".equals(fieldName)) {
                    deserializedManagedCassandraManagedServiceIdentity.principalId = reader.getString();
                } else if ("tenantId".equals(fieldName)) {
                    deserializedManagedCassandraManagedServiceIdentity.tenantId = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedManagedCassandraManagedServiceIdentity.type
                        = ManagedCassandraResourceIdentityType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedCassandraManagedServiceIdentity;
        });
    }
}
