// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.LocationGetResultInner;
import java.io.IOException;
import java.util.List;

/**
 * The List operation response, that contains Cosmos DB locations and their properties.
 */
@Immutable
public final class LocationListResult implements JsonSerializable<LocationListResult> {
    /*
     * List of Cosmos DB locations and their properties.
     */
    private List<LocationGetResultInner> value;

    /**
     * Creates an instance of LocationListResult class.
     */
    public LocationListResult() {
    }

    /**
     * Get the value property: List of Cosmos DB locations and their properties.
     * 
     * @return the value value.
     */
    public List<LocationGetResultInner> value() {
        return this.value;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LocationListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LocationListResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the LocationListResult.
     */
    public static LocationListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LocationListResult deserializedLocationListResult = new LocationListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<LocationGetResultInner> value
                        = reader.readArray(reader1 -> LocationGetResultInner.fromJson(reader1));
                    deserializedLocationListResult.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLocationListResult;
        });
    }
}
