// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The definition of a computed property.
 */
@Fluent
public final class ComputedProperty implements JsonSerializable<ComputedProperty> {
    /*
     * The name of a computed property, for example - "cp_lowerName"
     */
    private String name;

    /*
     * The query that evaluates the value for computed property, for example - "SELECT VALUE LOWER(c.name) FROM c"
     */
    private String query;

    /**
     * Creates an instance of ComputedProperty class.
     */
    public ComputedProperty() {
    }

    /**
     * Get the name property: The name of a computed property, for example - "cp_lowerName".
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of a computed property, for example - "cp_lowerName".
     * 
     * @param name the name value to set.
     * @return the ComputedProperty object itself.
     */
    public ComputedProperty withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the query property: The query that evaluates the value for computed property, for example - "SELECT VALUE
     * LOWER(c.name) FROM c".
     * 
     * @return the query value.
     */
    public String query() {
        return this.query;
    }

    /**
     * Set the query property: The query that evaluates the value for computed property, for example - "SELECT VALUE
     * LOWER(c.name) FROM c".
     * 
     * @param query the query value to set.
     * @return the ComputedProperty object itself.
     */
    public ComputedProperty withQuery(String query) {
        this.query = query;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("query", this.query);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ComputedProperty from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ComputedProperty if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ComputedProperty.
     */
    public static ComputedProperty fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ComputedProperty deserializedComputedProperty = new ComputedProperty();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedComputedProperty.name = reader.getString();
                } else if ("query".equals(fieldName)) {
                    deserializedComputedProperty.query = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedComputedProperty;
        });
    }
}
