// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Cosmos DB Cassandra keyspace resource object.
 */
@Fluent
public class CassandraKeyspaceResource implements JsonSerializable<CassandraKeyspaceResource> {
    /*
     * Name of the Cosmos DB Cassandra keyspace
     */
    private String id;

    /**
     * Creates an instance of CassandraKeyspaceResource class.
     */
    public CassandraKeyspaceResource() {
    }

    /**
     * Get the id property: Name of the Cosmos DB Cassandra keyspace.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Name of the Cosmos DB Cassandra keyspace.
     * 
     * @param id the id value to set.
     * @return the CassandraKeyspaceResource object itself.
     */
    public CassandraKeyspaceResource withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (id() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property id in model CassandraKeyspaceResource"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CassandraKeyspaceResource.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CassandraKeyspaceResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CassandraKeyspaceResource if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CassandraKeyspaceResource.
     */
    public static CassandraKeyspaceResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CassandraKeyspaceResource deserializedCassandraKeyspaceResource = new CassandraKeyspaceResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedCassandraKeyspaceResource.id = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCassandraKeyspaceResource;
        });
    }
}
