// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Cosmos DB provisioned throughput settings object.
 */
@Fluent
public final class AutoscaleSettingsResource implements JsonSerializable<AutoscaleSettingsResource> {
    /*
     * Represents maximum throughput container can scale up to.
     */
    private int maxThroughput;

    /*
     * Cosmos DB resource auto-upgrade policy
     */
    private AutoUpgradePolicyResource autoUpgradePolicy;

    /*
     * Represents target maximum throughput container can scale up to once offer is no longer in pending state.
     */
    private Integer targetMaxThroughput;

    /**
     * Creates an instance of AutoscaleSettingsResource class.
     */
    public AutoscaleSettingsResource() {
    }

    /**
     * Get the maxThroughput property: Represents maximum throughput container can scale up to.
     * 
     * @return the maxThroughput value.
     */
    public int maxThroughput() {
        return this.maxThroughput;
    }

    /**
     * Set the maxThroughput property: Represents maximum throughput container can scale up to.
     * 
     * @param maxThroughput the maxThroughput value to set.
     * @return the AutoscaleSettingsResource object itself.
     */
    public AutoscaleSettingsResource withMaxThroughput(int maxThroughput) {
        this.maxThroughput = maxThroughput;
        return this;
    }

    /**
     * Get the autoUpgradePolicy property: Cosmos DB resource auto-upgrade policy.
     * 
     * @return the autoUpgradePolicy value.
     */
    public AutoUpgradePolicyResource autoUpgradePolicy() {
        return this.autoUpgradePolicy;
    }

    /**
     * Set the autoUpgradePolicy property: Cosmos DB resource auto-upgrade policy.
     * 
     * @param autoUpgradePolicy the autoUpgradePolicy value to set.
     * @return the AutoscaleSettingsResource object itself.
     */
    public AutoscaleSettingsResource withAutoUpgradePolicy(AutoUpgradePolicyResource autoUpgradePolicy) {
        this.autoUpgradePolicy = autoUpgradePolicy;
        return this;
    }

    /**
     * Get the targetMaxThroughput property: Represents target maximum throughput container can scale up to once offer
     * is no longer in pending state.
     * 
     * @return the targetMaxThroughput value.
     */
    public Integer targetMaxThroughput() {
        return this.targetMaxThroughput;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (autoUpgradePolicy() != null) {
            autoUpgradePolicy().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("maxThroughput", this.maxThroughput);
        jsonWriter.writeJsonField("autoUpgradePolicy", this.autoUpgradePolicy);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AutoscaleSettingsResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AutoscaleSettingsResource if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AutoscaleSettingsResource.
     */
    public static AutoscaleSettingsResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AutoscaleSettingsResource deserializedAutoscaleSettingsResource = new AutoscaleSettingsResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("maxThroughput".equals(fieldName)) {
                    deserializedAutoscaleSettingsResource.maxThroughput = reader.getInt();
                } else if ("autoUpgradePolicy".equals(fieldName)) {
                    deserializedAutoscaleSettingsResource.autoUpgradePolicy
                        = AutoUpgradePolicyResource.fromJson(reader);
                } else if ("targetMaxThroughput".equals(fieldName)) {
                    deserializedAutoscaleSettingsResource.targetMaxThroughput = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAutoscaleSettingsResource;
        });
    }
}
