// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.ArmProxyResource;
import com.azure.resourcemanager.cosmos.models.Permission;
import com.azure.resourcemanager.cosmos.models.RoleDefinitionType;
import java.io.IOException;
import java.util.List;

/**
 * An Azure Cosmos DB SQL Role Definition.
 */
@Fluent
public final class SqlRoleDefinitionGetResultsInner extends ArmProxyResource {
    /*
     * Properties related to the Role Definition.
     */
    private SqlRoleDefinitionResource innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of SqlRoleDefinitionGetResultsInner class.
     */
    public SqlRoleDefinitionGetResultsInner() {
    }

    /**
     * Get the innerProperties property: Properties related to the Role Definition.
     * 
     * @return the innerProperties value.
     */
    private SqlRoleDefinitionResource innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the roleName property: A user-friendly name for the Role Definition. Must be unique for the database account.
     * 
     * @return the roleName value.
     */
    public String roleName() {
        return this.innerProperties() == null ? null : this.innerProperties().roleName();
    }

    /**
     * Set the roleName property: A user-friendly name for the Role Definition. Must be unique for the database account.
     * 
     * @param roleName the roleName value to set.
     * @return the SqlRoleDefinitionGetResultsInner object itself.
     */
    public SqlRoleDefinitionGetResultsInner withRoleName(String roleName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SqlRoleDefinitionResource();
        }
        this.innerProperties().withRoleName(roleName);
        return this;
    }

    /**
     * Get the type property: Indicates whether the Role Definition was built-in or user created.
     * 
     * @return the type value.
     */
    public RoleDefinitionType typePropertiesType() {
        return this.innerProperties() == null ? null : this.innerProperties().type();
    }

    /**
     * Set the type property: Indicates whether the Role Definition was built-in or user created.
     * 
     * @param type the type value to set.
     * @return the SqlRoleDefinitionGetResultsInner object itself.
     */
    public SqlRoleDefinitionGetResultsInner withTypePropertiesType(RoleDefinitionType type) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SqlRoleDefinitionResource();
        }
        this.innerProperties().withType(type);
        return this;
    }

    /**
     * Get the assignableScopes property: A set of fully qualified Scopes at or below which Role Assignments may be
     * created using this Role Definition. This will allow application of this Role Definition on the entire database
     * account or any underlying Database / Collection. Must have at least one element. Scopes higher than Database
     * account are not enforceable as assignable Scopes. Note that resources referenced in assignable Scopes need not
     * exist.
     * 
     * @return the assignableScopes value.
     */
    public List<String> assignableScopes() {
        return this.innerProperties() == null ? null : this.innerProperties().assignableScopes();
    }

    /**
     * Set the assignableScopes property: A set of fully qualified Scopes at or below which Role Assignments may be
     * created using this Role Definition. This will allow application of this Role Definition on the entire database
     * account or any underlying Database / Collection. Must have at least one element. Scopes higher than Database
     * account are not enforceable as assignable Scopes. Note that resources referenced in assignable Scopes need not
     * exist.
     * 
     * @param assignableScopes the assignableScopes value to set.
     * @return the SqlRoleDefinitionGetResultsInner object itself.
     */
    public SqlRoleDefinitionGetResultsInner withAssignableScopes(List<String> assignableScopes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SqlRoleDefinitionResource();
        }
        this.innerProperties().withAssignableScopes(assignableScopes);
        return this;
    }

    /**
     * Get the permissions property: The set of operations allowed through this Role Definition.
     * 
     * @return the permissions value.
     */
    public List<Permission> permissions() {
        return this.innerProperties() == null ? null : this.innerProperties().permissions();
    }

    /**
     * Set the permissions property: The set of operations allowed through this Role Definition.
     * 
     * @param permissions the permissions value to set.
     * @return the SqlRoleDefinitionGetResultsInner object itself.
     */
    public SqlRoleDefinitionGetResultsInner withPermissions(List<Permission> permissions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SqlRoleDefinitionResource();
        }
        this.innerProperties().withPermissions(permissions);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SqlRoleDefinitionGetResultsInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SqlRoleDefinitionGetResultsInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SqlRoleDefinitionGetResultsInner.
     */
    public static SqlRoleDefinitionGetResultsInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SqlRoleDefinitionGetResultsInner deserializedSqlRoleDefinitionGetResultsInner
                = new SqlRoleDefinitionGetResultsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedSqlRoleDefinitionGetResultsInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedSqlRoleDefinitionGetResultsInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedSqlRoleDefinitionGetResultsInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedSqlRoleDefinitionGetResultsInner.innerProperties
                        = SqlRoleDefinitionResource.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSqlRoleDefinitionGetResultsInner;
        });
    }
}
