// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.ArmProxyResource;
import com.azure.resourcemanager.cosmos.models.ServiceResourceProperties;
import java.io.IOException;

/**
 * Properties for the database account.
 */
@Fluent
public final class ServiceResourceInner extends ArmProxyResource {
    /*
     * Services response resource.
     */
    private ServiceResourceProperties properties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ServiceResourceInner class.
     */
    public ServiceResourceInner() {
    }

    /**
     * Get the properties property: Services response resource.
     * 
     * @return the properties value.
     */
    public ServiceResourceProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Services response resource.
     * 
     * @param properties the properties value to set.
     * @return the ServiceResourceInner object itself.
     */
    public ServiceResourceInner withProperties(ServiceResourceProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServiceResourceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServiceResourceInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ServiceResourceInner.
     */
    public static ServiceResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServiceResourceInner deserializedServiceResourceInner = new ServiceResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedServiceResourceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedServiceResourceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedServiceResourceInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedServiceResourceInner.properties = ServiceResourceProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServiceResourceInner;
        });
    }
}
