/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.CreateUpdateOptions;
import com.azure.resourcemanager.cosmos.models.SqlDatabaseResource;
import java.io.IOException;

public final class SqlDatabaseCreateUpdateProperties
implements JsonSerializable<SqlDatabaseCreateUpdateProperties> {
    private SqlDatabaseResource resource;
    private CreateUpdateOptions options;
    private static final ClientLogger LOGGER = new ClientLogger(SqlDatabaseCreateUpdateProperties.class);

    public SqlDatabaseResource resource() {
        return this.resource;
    }

    public SqlDatabaseCreateUpdateProperties withResource(SqlDatabaseResource resource) {
        this.resource = resource;
        return this;
    }

    public CreateUpdateOptions options() {
        return this.options;
    }

    public SqlDatabaseCreateUpdateProperties withOptions(CreateUpdateOptions options) {
        this.options = options;
        return this;
    }

    public void validate() {
        if (this.resource() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property resource in model SqlDatabaseCreateUpdateProperties"));
        }
        this.resource().validate();
        if (this.options() != null) {
            this.options().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("resource", (JsonSerializable)this.resource);
        jsonWriter.writeJsonField("options", (JsonSerializable)this.options);
        return jsonWriter.writeEndObject();
    }

    public static SqlDatabaseCreateUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SqlDatabaseCreateUpdateProperties)jsonReader.readObject(reader -> {
            SqlDatabaseCreateUpdateProperties deserializedSqlDatabaseCreateUpdateProperties = new SqlDatabaseCreateUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resource".equals(fieldName)) {
                    deserializedSqlDatabaseCreateUpdateProperties.resource = SqlDatabaseResource.fromJson(reader);
                    continue;
                }
                if ("options".equals(fieldName)) {
                    deserializedSqlDatabaseCreateUpdateProperties.options = CreateUpdateOptions.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSqlDatabaseCreateUpdateProperties;
        });
    }
}

