// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The index type of the vector. Currently, flat, diskANN, and quantizedFlat are supported.
 */
public final class VectorIndexType extends ExpandableStringEnum<VectorIndexType> {
    /**
     * Static value flat for VectorIndexType.
     */
    public static final VectorIndexType FLAT = fromString("flat");

    /**
     * Static value diskANN for VectorIndexType.
     */
    public static final VectorIndexType DISK_ANN = fromString("diskANN");

    /**
     * Static value quantizedFlat for VectorIndexType.
     */
    public static final VectorIndexType QUANTIZED_FLAT = fromString("quantizedFlat");

    /**
     * Creates a new instance of VectorIndexType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public VectorIndexType() {
    }

    /**
     * Creates or finds a VectorIndexType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding VectorIndexType.
     */
    public static VectorIndexType fromString(String name) {
        return fromString(name, VectorIndexType.class);
    }

    /**
     * Gets known VectorIndexType values.
     * 
     * @return known VectorIndexType values.
     */
    public static Collection<VectorIndexType> values() {
        return values(VectorIndexType.class);
    }
}
