// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents a vector embedding. A vector embedding is used to define a vector field in the documents.
 */
@Fluent
public final class VectorEmbedding implements JsonSerializable<VectorEmbedding> {
    /*
     * The path to the vector field in the document.
     */
    private String path;

    /*
     * Indicates the data type of vector.
     */
    private VectorDataType dataType;

    /*
     * The distance function to use for distance calculation in between vectors.
     */
    private DistanceFunction distanceFunction;

    /*
     * The number of dimensions in the vector.
     */
    private int dimensions;

    /**
     * Creates an instance of VectorEmbedding class.
     */
    public VectorEmbedding() {
    }

    /**
     * Get the path property: The path to the vector field in the document.
     * 
     * @return the path value.
     */
    public String path() {
        return this.path;
    }

    /**
     * Set the path property: The path to the vector field in the document.
     * 
     * @param path the path value to set.
     * @return the VectorEmbedding object itself.
     */
    public VectorEmbedding withPath(String path) {
        this.path = path;
        return this;
    }

    /**
     * Get the dataType property: Indicates the data type of vector.
     * 
     * @return the dataType value.
     */
    public VectorDataType dataType() {
        return this.dataType;
    }

    /**
     * Set the dataType property: Indicates the data type of vector.
     * 
     * @param dataType the dataType value to set.
     * @return the VectorEmbedding object itself.
     */
    public VectorEmbedding withDataType(VectorDataType dataType) {
        this.dataType = dataType;
        return this;
    }

    /**
     * Get the distanceFunction property: The distance function to use for distance calculation in between vectors.
     * 
     * @return the distanceFunction value.
     */
    public DistanceFunction distanceFunction() {
        return this.distanceFunction;
    }

    /**
     * Set the distanceFunction property: The distance function to use for distance calculation in between vectors.
     * 
     * @param distanceFunction the distanceFunction value to set.
     * @return the VectorEmbedding object itself.
     */
    public VectorEmbedding withDistanceFunction(DistanceFunction distanceFunction) {
        this.distanceFunction = distanceFunction;
        return this;
    }

    /**
     * Get the dimensions property: The number of dimensions in the vector.
     * 
     * @return the dimensions value.
     */
    public int dimensions() {
        return this.dimensions;
    }

    /**
     * Set the dimensions property: The number of dimensions in the vector.
     * 
     * @param dimensions the dimensions value to set.
     * @return the VectorEmbedding object itself.
     */
    public VectorEmbedding withDimensions(int dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (path() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property path in model VectorEmbedding"));
        }
        if (dataType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property dataType in model VectorEmbedding"));
        }
        if (distanceFunction() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property distanceFunction in model VectorEmbedding"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(VectorEmbedding.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("path", this.path);
        jsonWriter.writeStringField("dataType", this.dataType == null ? null : this.dataType.toString());
        jsonWriter.writeStringField("distanceFunction",
            this.distanceFunction == null ? null : this.distanceFunction.toString());
        jsonWriter.writeIntField("dimensions", this.dimensions);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VectorEmbedding from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VectorEmbedding if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VectorEmbedding.
     */
    public static VectorEmbedding fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VectorEmbedding deserializedVectorEmbedding = new VectorEmbedding();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("path".equals(fieldName)) {
                    deserializedVectorEmbedding.path = reader.getString();
                } else if ("dataType".equals(fieldName)) {
                    deserializedVectorEmbedding.dataType = VectorDataType.fromString(reader.getString());
                } else if ("distanceFunction".equals(fieldName)) {
                    deserializedVectorEmbedding.distanceFunction = DistanceFunction.fromString(reader.getString());
                } else if ("dimensions".equals(fieldName)) {
                    deserializedVectorEmbedding.dimensions = reader.getInt();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVectorEmbedding;
        });
    }
}
