// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Indicates the data type of vector.
 */
public final class VectorDataType extends ExpandableStringEnum<VectorDataType> {
    /**
     * Static value float32 for VectorDataType.
     */
    public static final VectorDataType FLOAT32 = fromString("float32");

    /**
     * Static value uint8 for VectorDataType.
     */
    public static final VectorDataType UINT8 = fromString("uint8");

    /**
     * Static value int8 for VectorDataType.
     */
    public static final VectorDataType INT8 = fromString("int8");

    /**
     * Creates a new instance of VectorDataType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public VectorDataType() {
    }

    /**
     * Creates or finds a VectorDataType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding VectorDataType.
     */
    public static VectorDataType fromString(String name) {
        return fromString(name, VectorDataType.class);
    }

    /**
     * Gets known VectorDataType values.
     * 
     * @return known VectorDataType values.
     */
    public static Collection<VectorDataType> values() {
        return values(VectorDataType.class);
    }
}
