// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Cosmos DB SQL trigger resource object.
 */
@Fluent
public class SqlTriggerResource implements JsonSerializable<SqlTriggerResource> {
    /*
     * Name of the Cosmos DB SQL trigger
     */
    private String id;

    /*
     * Body of the Trigger
     */
    private String body;

    /*
     * Type of the Trigger
     */
    private TriggerType triggerType;

    /*
     * The operation the trigger is associated with
     */
    private TriggerOperation triggerOperation;

    /**
     * Creates an instance of SqlTriggerResource class.
     */
    public SqlTriggerResource() {
    }

    /**
     * Get the id property: Name of the Cosmos DB SQL trigger.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Name of the Cosmos DB SQL trigger.
     * 
     * @param id the id value to set.
     * @return the SqlTriggerResource object itself.
     */
    public SqlTriggerResource withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the body property: Body of the Trigger.
     * 
     * @return the body value.
     */
    public String body() {
        return this.body;
    }

    /**
     * Set the body property: Body of the Trigger.
     * 
     * @param body the body value to set.
     * @return the SqlTriggerResource object itself.
     */
    public SqlTriggerResource withBody(String body) {
        this.body = body;
        return this;
    }

    /**
     * Get the triggerType property: Type of the Trigger.
     * 
     * @return the triggerType value.
     */
    public TriggerType triggerType() {
        return this.triggerType;
    }

    /**
     * Set the triggerType property: Type of the Trigger.
     * 
     * @param triggerType the triggerType value to set.
     * @return the SqlTriggerResource object itself.
     */
    public SqlTriggerResource withTriggerType(TriggerType triggerType) {
        this.triggerType = triggerType;
        return this;
    }

    /**
     * Get the triggerOperation property: The operation the trigger is associated with.
     * 
     * @return the triggerOperation value.
     */
    public TriggerOperation triggerOperation() {
        return this.triggerOperation;
    }

    /**
     * Set the triggerOperation property: The operation the trigger is associated with.
     * 
     * @param triggerOperation the triggerOperation value to set.
     * @return the SqlTriggerResource object itself.
     */
    public SqlTriggerResource withTriggerOperation(TriggerOperation triggerOperation) {
        this.triggerOperation = triggerOperation;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (id() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property id in model SqlTriggerResource"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SqlTriggerResource.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("body", this.body);
        jsonWriter.writeStringField("triggerType", this.triggerType == null ? null : this.triggerType.toString());
        jsonWriter.writeStringField("triggerOperation",
            this.triggerOperation == null ? null : this.triggerOperation.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SqlTriggerResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SqlTriggerResource if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SqlTriggerResource.
     */
    public static SqlTriggerResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SqlTriggerResource deserializedSqlTriggerResource = new SqlTriggerResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedSqlTriggerResource.id = reader.getString();
                } else if ("body".equals(fieldName)) {
                    deserializedSqlTriggerResource.body = reader.getString();
                } else if ("triggerType".equals(fieldName)) {
                    deserializedSqlTriggerResource.triggerType = TriggerType.fromString(reader.getString());
                } else if ("triggerOperation".equals(fieldName)) {
                    deserializedSqlTriggerResource.triggerOperation = TriggerOperation.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSqlTriggerResource;
        });
    }
}
