// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Cosmos DB SQL storedProcedure resource object.
 */
@Fluent
public class SqlStoredProcedureResource implements JsonSerializable<SqlStoredProcedureResource> {
    /*
     * Name of the Cosmos DB SQL storedProcedure
     */
    private String id;

    /*
     * Body of the Stored Procedure
     */
    private String body;

    /**
     * Creates an instance of SqlStoredProcedureResource class.
     */
    public SqlStoredProcedureResource() {
    }

    /**
     * Get the id property: Name of the Cosmos DB SQL storedProcedure.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Name of the Cosmos DB SQL storedProcedure.
     * 
     * @param id the id value to set.
     * @return the SqlStoredProcedureResource object itself.
     */
    public SqlStoredProcedureResource withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the body property: Body of the Stored Procedure.
     * 
     * @return the body value.
     */
    public String body() {
        return this.body;
    }

    /**
     * Set the body property: Body of the Stored Procedure.
     * 
     * @param body the body value to set.
     * @return the SqlStoredProcedureResource object itself.
     */
    public SqlStoredProcedureResource withBody(String body) {
        this.body = body;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (id() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property id in model SqlStoredProcedureResource"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SqlStoredProcedureResource.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("body", this.body);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SqlStoredProcedureResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SqlStoredProcedureResource if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SqlStoredProcedureResource.
     */
    public static SqlStoredProcedureResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SqlStoredProcedureResource deserializedSqlStoredProcedureResource = new SqlStoredProcedureResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedSqlStoredProcedureResource.id = reader.getString();
                } else if ("body".equals(fieldName)) {
                    deserializedSqlStoredProcedureResource.body = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSqlStoredProcedureResource;
        });
    }
}
