// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The SeedNode model.
 */
@Fluent
public final class SeedNode implements JsonSerializable<SeedNode> {
    /*
     * IP address of this seed node.
     */
    private String ipAddress;

    /**
     * Creates an instance of SeedNode class.
     */
    public SeedNode() {
    }

    /**
     * Get the ipAddress property: IP address of this seed node.
     * 
     * @return the ipAddress value.
     */
    public String ipAddress() {
        return this.ipAddress;
    }

    /**
     * Set the ipAddress property: IP address of this seed node.
     * 
     * @param ipAddress the ipAddress value to set.
     * @return the SeedNode object itself.
     */
    public SeedNode withIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ipAddress", this.ipAddress);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SeedNode from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SeedNode if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the SeedNode.
     */
    public static SeedNode fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SeedNode deserializedSeedNode = new SeedNode();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("ipAddress".equals(fieldName)) {
                    deserializedSeedNode.ipAddress = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSeedNode;
        });
    }
}
