// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The set of roles permitted through this Role Definition.
 */
@Fluent
public final class Role implements JsonSerializable<Role> {
    /*
     * The database name the role is applied.
     */
    private String db;

    /*
     * The role name.
     */
    private String role;

    /**
     * Creates an instance of Role class.
     */
    public Role() {
    }

    /**
     * Get the db property: The database name the role is applied.
     * 
     * @return the db value.
     */
    public String db() {
        return this.db;
    }

    /**
     * Set the db property: The database name the role is applied.
     * 
     * @param db the db value to set.
     * @return the Role object itself.
     */
    public Role withDb(String db) {
        this.db = db;
        return this;
    }

    /**
     * Get the role property: The role name.
     * 
     * @return the role value.
     */
    public String role() {
        return this.role;
    }

    /**
     * Set the role property: The role name.
     * 
     * @param role the role value to set.
     * @return the Role object itself.
     */
    public Role withRole(String role) {
        this.role = role;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("db", this.db);
        jsonWriter.writeStringField("role", this.role);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Role from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Role if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IOException If an error occurs while reading the Role.
     */
    public static Role fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Role deserializedRole = new Role();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("db".equals(fieldName)) {
                    deserializedRole.db = reader.getString();
                } else if ("role".equals(fieldName)) {
                    deserializedRole.role = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRole;
        });
    }
}
