// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.RestorableTableResourcesGetResultInner;
import java.io.IOException;
import java.util.List;

/**
 * List of restorable table names.
 */
@Immutable
public final class RestorableTableResourcesListResult implements JsonSerializable<RestorableTableResourcesListResult> {
    /*
     * List of restorable table names.
     */
    private List<RestorableTableResourcesGetResultInner> value;

    /**
     * Creates an instance of RestorableTableResourcesListResult class.
     */
    public RestorableTableResourcesListResult() {
    }

    /**
     * Get the value property: List of restorable table names.
     * 
     * @return the value value.
     */
    public List<RestorableTableResourcesGetResultInner> value() {
        return this.value;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RestorableTableResourcesListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RestorableTableResourcesListResult if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RestorableTableResourcesListResult.
     */
    public static RestorableTableResourcesListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RestorableTableResourcesListResult deserializedRestorableTableResourcesListResult
                = new RestorableTableResourcesListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<RestorableTableResourcesGetResultInner> value
                        = reader.readArray(reader1 -> RestorableTableResourcesGetResultInner.fromJson(reader1));
                    deserializedRestorableTableResourcesListResult.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRestorableTableResourcesListResult;
        });
    }
}
