// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.RestorableSqlResourcesGetResultInner;
import java.io.IOException;
import java.util.List;

/**
 * The List operation response, that contains the restorable SQL resources.
 */
@Immutable
public final class RestorableSqlResourcesListResult implements JsonSerializable<RestorableSqlResourcesListResult> {
    /*
     * List of restorable SQL resources, including the database and collection names.
     */
    private List<RestorableSqlResourcesGetResultInner> value;

    /**
     * Creates an instance of RestorableSqlResourcesListResult class.
     */
    public RestorableSqlResourcesListResult() {
    }

    /**
     * Get the value property: List of restorable SQL resources, including the database and collection names.
     * 
     * @return the value value.
     */
    public List<RestorableSqlResourcesGetResultInner> value() {
        return this.value;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RestorableSqlResourcesListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RestorableSqlResourcesListResult if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RestorableSqlResourcesListResult.
     */
    public static RestorableSqlResourcesListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RestorableSqlResourcesListResult deserializedRestorableSqlResourcesListResult
                = new RestorableSqlResourcesListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<RestorableSqlResourcesGetResultInner> value
                        = reader.readArray(reader1 -> RestorableSqlResourcesGetResultInner.fromJson(reader1));
                    deserializedRestorableSqlResourcesListResult.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRestorableSqlResourcesListResult;
        });
    }
}
