// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The resource of an Azure Cosmos DB SQL container event.
 */
@Fluent
public final class RestorableSqlContainerPropertiesResource
    implements JsonSerializable<RestorableSqlContainerPropertiesResource> {
    /*
     * A system generated property. A unique identifier.
     */
    private String rid;

    /*
     * The operation type of this container event.
     */
    private OperationType operationType;

    /*
     * A state of this container to identify if this container is restorable in same account.
     */
    private String canUndelete;

    /*
     * The reason why this container can not be restored in same account.
     */
    private String canUndeleteReason;

    /*
     * The when this container event happened.
     */
    private String eventTimestamp;

    /*
     * The name of this SQL container.
     */
    private String ownerId;

    /*
     * The resource ID of this SQL container.
     */
    private String ownerResourceId;

    /*
     * Cosmos DB SQL container resource object
     */
    private RestorableSqlContainerPropertiesResourceContainer container;

    /**
     * Creates an instance of RestorableSqlContainerPropertiesResource class.
     */
    public RestorableSqlContainerPropertiesResource() {
    }

    /**
     * Get the rid property: A system generated property. A unique identifier.
     * 
     * @return the rid value.
     */
    public String rid() {
        return this.rid;
    }

    /**
     * Get the operationType property: The operation type of this container event.
     * 
     * @return the operationType value.
     */
    public OperationType operationType() {
        return this.operationType;
    }

    /**
     * Get the canUndelete property: A state of this container to identify if this container is restorable in same
     * account.
     * 
     * @return the canUndelete value.
     */
    public String canUndelete() {
        return this.canUndelete;
    }

    /**
     * Get the canUndeleteReason property: The reason why this container can not be restored in same account.
     * 
     * @return the canUndeleteReason value.
     */
    public String canUndeleteReason() {
        return this.canUndeleteReason;
    }

    /**
     * Get the eventTimestamp property: The when this container event happened.
     * 
     * @return the eventTimestamp value.
     */
    public String eventTimestamp() {
        return this.eventTimestamp;
    }

    /**
     * Get the ownerId property: The name of this SQL container.
     * 
     * @return the ownerId value.
     */
    public String ownerId() {
        return this.ownerId;
    }

    /**
     * Get the ownerResourceId property: The resource ID of this SQL container.
     * 
     * @return the ownerResourceId value.
     */
    public String ownerResourceId() {
        return this.ownerResourceId;
    }

    /**
     * Get the container property: Cosmos DB SQL container resource object.
     * 
     * @return the container value.
     */
    public RestorableSqlContainerPropertiesResourceContainer container() {
        return this.container;
    }

    /**
     * Set the container property: Cosmos DB SQL container resource object.
     * 
     * @param container the container value to set.
     * @return the RestorableSqlContainerPropertiesResource object itself.
     */
    public RestorableSqlContainerPropertiesResource
        withContainer(RestorableSqlContainerPropertiesResourceContainer container) {
        this.container = container;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (container() != null) {
            container().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("container", this.container);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RestorableSqlContainerPropertiesResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RestorableSqlContainerPropertiesResource if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RestorableSqlContainerPropertiesResource.
     */
    public static RestorableSqlContainerPropertiesResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RestorableSqlContainerPropertiesResource deserializedRestorableSqlContainerPropertiesResource
                = new RestorableSqlContainerPropertiesResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("_rid".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResource.rid = reader.getString();
                } else if ("operationType".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResource.operationType
                        = OperationType.fromString(reader.getString());
                } else if ("canUndelete".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResource.canUndelete = reader.getString();
                } else if ("canUndeleteReason".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResource.canUndeleteReason = reader.getString();
                } else if ("eventTimestamp".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResource.eventTimestamp = reader.getString();
                } else if ("ownerId".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResource.ownerId = reader.getString();
                } else if ("ownerResourceId".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResource.ownerResourceId = reader.getString();
                } else if ("container".equals(fieldName)) {
                    deserializedRestorableSqlContainerPropertiesResource.container
                        = RestorableSqlContainerPropertiesResourceContainer.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRestorableSqlContainerPropertiesResource;
        });
    }
}
