// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The set of data plane operations permitted through this Role Definition.
 */
@Fluent
public final class Privilege implements JsonSerializable<Privilege> {
    /*
     * An Azure Cosmos DB Mongo DB Resource.
     */
    private PrivilegeResource resource;

    /*
     * An array of actions that are allowed.
     */
    private List<String> actions;

    /**
     * Creates an instance of Privilege class.
     */
    public Privilege() {
    }

    /**
     * Get the resource property: An Azure Cosmos DB Mongo DB Resource.
     * 
     * @return the resource value.
     */
    public PrivilegeResource resource() {
        return this.resource;
    }

    /**
     * Set the resource property: An Azure Cosmos DB Mongo DB Resource.
     * 
     * @param resource the resource value to set.
     * @return the Privilege object itself.
     */
    public Privilege withResource(PrivilegeResource resource) {
        this.resource = resource;
        return this;
    }

    /**
     * Get the actions property: An array of actions that are allowed.
     * 
     * @return the actions value.
     */
    public List<String> actions() {
        return this.actions;
    }

    /**
     * Set the actions property: An array of actions that are allowed.
     * 
     * @param actions the actions value to set.
     * @return the Privilege object itself.
     */
    public Privilege withActions(List<String> actions) {
        this.actions = actions;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resource() != null) {
            resource().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("resource", this.resource);
        jsonWriter.writeArrayField("actions", this.actions, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Privilege from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Privilege if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the Privilege.
     */
    public static Privilege fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Privilege deserializedPrivilege = new Privilege();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("resource".equals(fieldName)) {
                    deserializedPrivilege.resource = PrivilegeResource.fromJson(reader);
                } else if ("actions".equals(fieldName)) {
                    List<String> actions = reader.readArray(reader1 -> reader1.getString());
                    deserializedPrivilege.actions = actions;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPrivilege;
        });
    }
}
