// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Connection State of the Private Endpoint Connection.
 */
@Fluent
public final class PrivateLinkServiceConnectionStateProperty
    implements JsonSerializable<PrivateLinkServiceConnectionStateProperty> {
    /*
     * The private link service connection status.
     */
    private String status;

    /*
     * The private link service connection description.
     */
    private String description;

    /*
     * Any action that is required beyond basic workflow (approve/ reject/ disconnect)
     */
    private String actionsRequired;

    /**
     * Creates an instance of PrivateLinkServiceConnectionStateProperty class.
     */
    public PrivateLinkServiceConnectionStateProperty() {
    }

    /**
     * Get the status property: The private link service connection status.
     * 
     * @return the status value.
     */
    public String status() {
        return this.status;
    }

    /**
     * Set the status property: The private link service connection status.
     * 
     * @param status the status value to set.
     * @return the PrivateLinkServiceConnectionStateProperty object itself.
     */
    public PrivateLinkServiceConnectionStateProperty withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
     * Get the description property: The private link service connection description.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The private link service connection description.
     * 
     * @param description the description value to set.
     * @return the PrivateLinkServiceConnectionStateProperty object itself.
     */
    public PrivateLinkServiceConnectionStateProperty withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the actionsRequired property: Any action that is required beyond basic workflow (approve/ reject/
     * disconnect).
     * 
     * @return the actionsRequired value.
     */
    public String actionsRequired() {
        return this.actionsRequired;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PrivateLinkServiceConnectionStateProperty from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PrivateLinkServiceConnectionStateProperty if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PrivateLinkServiceConnectionStateProperty.
     */
    public static PrivateLinkServiceConnectionStateProperty fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PrivateLinkServiceConnectionStateProperty deserializedPrivateLinkServiceConnectionStateProperty
                = new PrivateLinkServiceConnectionStateProperty();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("status".equals(fieldName)) {
                    deserializedPrivateLinkServiceConnectionStateProperty.status = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedPrivateLinkServiceConnectionStateProperty.description = reader.getString();
                } else if ("actionsRequired".equals(fieldName)) {
                    deserializedPrivateLinkServiceConnectionStateProperty.actionsRequired = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPrivateLinkServiceConnectionStateProperty;
        });
    }
}
