// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Configuration values for periodic mode backup.
 */
@Fluent
public final class PeriodicModeProperties implements JsonSerializable<PeriodicModeProperties> {
    /*
     * An integer representing the interval in minutes between two backups
     */
    private Integer backupIntervalInMinutes;

    /*
     * An integer representing the time (in hours) that each backup is retained
     */
    private Integer backupRetentionIntervalInHours;

    /*
     * Enum to indicate type of backup residency
     */
    private BackupStorageRedundancy backupStorageRedundancy;

    /**
     * Creates an instance of PeriodicModeProperties class.
     */
    public PeriodicModeProperties() {
    }

    /**
     * Get the backupIntervalInMinutes property: An integer representing the interval in minutes between two backups.
     * 
     * @return the backupIntervalInMinutes value.
     */
    public Integer backupIntervalInMinutes() {
        return this.backupIntervalInMinutes;
    }

    /**
     * Set the backupIntervalInMinutes property: An integer representing the interval in minutes between two backups.
     * 
     * @param backupIntervalInMinutes the backupIntervalInMinutes value to set.
     * @return the PeriodicModeProperties object itself.
     */
    public PeriodicModeProperties withBackupIntervalInMinutes(Integer backupIntervalInMinutes) {
        this.backupIntervalInMinutes = backupIntervalInMinutes;
        return this;
    }

    /**
     * Get the backupRetentionIntervalInHours property: An integer representing the time (in hours) that each backup is
     * retained.
     * 
     * @return the backupRetentionIntervalInHours value.
     */
    public Integer backupRetentionIntervalInHours() {
        return this.backupRetentionIntervalInHours;
    }

    /**
     * Set the backupRetentionIntervalInHours property: An integer representing the time (in hours) that each backup is
     * retained.
     * 
     * @param backupRetentionIntervalInHours the backupRetentionIntervalInHours value to set.
     * @return the PeriodicModeProperties object itself.
     */
    public PeriodicModeProperties withBackupRetentionIntervalInHours(Integer backupRetentionIntervalInHours) {
        this.backupRetentionIntervalInHours = backupRetentionIntervalInHours;
        return this;
    }

    /**
     * Get the backupStorageRedundancy property: Enum to indicate type of backup residency.
     * 
     * @return the backupStorageRedundancy value.
     */
    public BackupStorageRedundancy backupStorageRedundancy() {
        return this.backupStorageRedundancy;
    }

    /**
     * Set the backupStorageRedundancy property: Enum to indicate type of backup residency.
     * 
     * @param backupStorageRedundancy the backupStorageRedundancy value to set.
     * @return the PeriodicModeProperties object itself.
     */
    public PeriodicModeProperties withBackupStorageRedundancy(BackupStorageRedundancy backupStorageRedundancy) {
        this.backupStorageRedundancy = backupStorageRedundancy;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("backupIntervalInMinutes", this.backupIntervalInMinutes);
        jsonWriter.writeNumberField("backupRetentionIntervalInHours", this.backupRetentionIntervalInHours);
        jsonWriter.writeStringField("backupStorageRedundancy",
            this.backupStorageRedundancy == null ? null : this.backupStorageRedundancy.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PeriodicModeProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PeriodicModeProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PeriodicModeProperties.
     */
    public static PeriodicModeProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PeriodicModeProperties deserializedPeriodicModeProperties = new PeriodicModeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("backupIntervalInMinutes".equals(fieldName)) {
                    deserializedPeriodicModeProperties.backupIntervalInMinutes = reader.getNullable(JsonReader::getInt);
                } else if ("backupRetentionIntervalInHours".equals(fieldName)) {
                    deserializedPeriodicModeProperties.backupRetentionIntervalInHours
                        = reader.getNullable(JsonReader::getInt);
                } else if ("backupStorageRedundancy".equals(fieldName)) {
                    deserializedPeriodicModeProperties.backupStorageRedundancy
                        = BackupStorageRedundancy.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPeriodicModeProperties;
        });
    }
}
