// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.NotebookWorkspaceInner;
import java.io.IOException;
import java.util.List;

/**
 * A list of notebook workspace resources.
 */
@Fluent
public final class NotebookWorkspaceListResult implements JsonSerializable<NotebookWorkspaceListResult> {
    /*
     * Array of notebook workspace resources
     */
    private List<NotebookWorkspaceInner> value;

    /**
     * Creates an instance of NotebookWorkspaceListResult class.
     */
    public NotebookWorkspaceListResult() {
    }

    /**
     * Get the value property: Array of notebook workspace resources.
     * 
     * @return the value value.
     */
    public List<NotebookWorkspaceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Array of notebook workspace resources.
     * 
     * @param value the value value to set.
     * @return the NotebookWorkspaceListResult object itself.
     */
    public NotebookWorkspaceListResult withValue(List<NotebookWorkspaceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NotebookWorkspaceListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NotebookWorkspaceListResult if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NotebookWorkspaceListResult.
     */
    public static NotebookWorkspaceListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NotebookWorkspaceListResult deserializedNotebookWorkspaceListResult = new NotebookWorkspaceListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<NotebookWorkspaceInner> value
                        = reader.readArray(reader1 -> NotebookWorkspaceInner.fromJson(reader1));
                    deserializedNotebookWorkspaceListResult.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNotebookWorkspaceListResult;
        });
    }
}
