// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * The MongoDBCollectionGetPropertiesResource model.
 */
@Fluent
public final class MongoDBCollectionGetPropertiesResource extends MongoDBCollectionResource {
    /*
     * A system generated property. A unique identifier.
     */
    private String rid;

    /*
     * A system generated property that denotes the last updated timestamp of the resource.
     */
    private Float ts;

    /*
     * A system generated property representing the resource etag required for optimistic concurrency control.
     */
    private String etag;

    /**
     * Creates an instance of MongoDBCollectionGetPropertiesResource class.
     */
    public MongoDBCollectionGetPropertiesResource() {
    }

    /**
     * Get the rid property: A system generated property. A unique identifier.
     * 
     * @return the rid value.
     */
    public String rid() {
        return this.rid;
    }

    /**
     * Get the ts property: A system generated property that denotes the last updated timestamp of the resource.
     * 
     * @return the ts value.
     */
    public Float ts() {
        return this.ts;
    }

    /**
     * Get the etag property: A system generated property representing the resource etag required for optimistic
     * concurrency control.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MongoDBCollectionGetPropertiesResource withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MongoDBCollectionGetPropertiesResource withShardKey(Map<String, String> shardKey) {
        super.withShardKey(shardKey);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MongoDBCollectionGetPropertiesResource withIndexes(List<MongoIndex> indexes) {
        super.withIndexes(indexes);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MongoDBCollectionGetPropertiesResource withAnalyticalStorageTtl(Integer analyticalStorageTtl) {
        super.withAnalyticalStorageTtl(analyticalStorageTtl);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MongoDBCollectionGetPropertiesResource withRestoreParameters(ResourceRestoreParameters restoreParameters) {
        super.withRestoreParameters(restoreParameters);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MongoDBCollectionGetPropertiesResource withCreateMode(CreateMode createMode) {
        super.withCreateMode(createMode);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (id() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property id in model MongoDBCollectionGetPropertiesResource"));
        }
        if (indexes() != null) {
            indexes().forEach(e -> e.validate());
        }
        if (restoreParameters() != null) {
            restoreParameters().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(MongoDBCollectionGetPropertiesResource.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeMapField("shardKey", shardKey(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("indexes", indexes(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeNumberField("analyticalStorageTtl", analyticalStorageTtl());
        jsonWriter.writeJsonField("restoreParameters", restoreParameters());
        jsonWriter.writeStringField("createMode", createMode() == null ? null : createMode().toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MongoDBCollectionGetPropertiesResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MongoDBCollectionGetPropertiesResource if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MongoDBCollectionGetPropertiesResource.
     */
    public static MongoDBCollectionGetPropertiesResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MongoDBCollectionGetPropertiesResource deserializedMongoDBCollectionGetPropertiesResource
                = new MongoDBCollectionGetPropertiesResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMongoDBCollectionGetPropertiesResource.withId(reader.getString());
                } else if ("shardKey".equals(fieldName)) {
                    Map<String, String> shardKey = reader.readMap(reader1 -> reader1.getString());
                    deserializedMongoDBCollectionGetPropertiesResource.withShardKey(shardKey);
                } else if ("indexes".equals(fieldName)) {
                    List<MongoIndex> indexes = reader.readArray(reader1 -> MongoIndex.fromJson(reader1));
                    deserializedMongoDBCollectionGetPropertiesResource.withIndexes(indexes);
                } else if ("analyticalStorageTtl".equals(fieldName)) {
                    deserializedMongoDBCollectionGetPropertiesResource
                        .withAnalyticalStorageTtl(reader.getNullable(JsonReader::getInt));
                } else if ("restoreParameters".equals(fieldName)) {
                    deserializedMongoDBCollectionGetPropertiesResource
                        .withRestoreParameters(ResourceRestoreParameters.fromJson(reader));
                } else if ("createMode".equals(fieldName)) {
                    deserializedMongoDBCollectionGetPropertiesResource
                        .withCreateMode(CreateMode.fromString(reader.getString()));
                } else if ("_rid".equals(fieldName)) {
                    deserializedMongoDBCollectionGetPropertiesResource.rid = reader.getString();
                } else if ("_ts".equals(fieldName)) {
                    deserializedMongoDBCollectionGetPropertiesResource.ts = reader.getNullable(JsonReader::getFloat);
                } else if ("_etag".equals(fieldName)) {
                    deserializedMongoDBCollectionGetPropertiesResource.etag = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMongoDBCollectionGetPropertiesResource;
        });
    }
}
