// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Cosmos DB location metadata.
 */
@Immutable
public final class LocationProperties implements JsonSerializable<LocationProperties> {
    /*
     * Flag indicating whether the location supports availability zones or not.
     */
    private Boolean supportsAvailabilityZone;

    /*
     * Flag indicating whether the location is residency sensitive.
     */
    private Boolean isResidencyRestricted;

    /*
     * The properties of available backup storage redundancies.
     */
    private List<BackupStorageRedundancy> backupStorageRedundancies;

    /*
     * Flag indicating whether the subscription have access in region for Non-Availability Zones.
     */
    private Boolean isSubscriptionRegionAccessAllowedForRegular;

    /*
     * Flag indicating whether the subscription have access in region for Availability Zones(Az).
     */
    private Boolean isSubscriptionRegionAccessAllowedForAz;

    /*
     * Enum to indicate current buildout status of the region.
     */
    private Status status;

    /**
     * Creates an instance of LocationProperties class.
     */
    public LocationProperties() {
    }

    /**
     * Get the supportsAvailabilityZone property: Flag indicating whether the location supports availability zones or
     * not.
     * 
     * @return the supportsAvailabilityZone value.
     */
    public Boolean supportsAvailabilityZone() {
        return this.supportsAvailabilityZone;
    }

    /**
     * Get the isResidencyRestricted property: Flag indicating whether the location is residency sensitive.
     * 
     * @return the isResidencyRestricted value.
     */
    public Boolean isResidencyRestricted() {
        return this.isResidencyRestricted;
    }

    /**
     * Get the backupStorageRedundancies property: The properties of available backup storage redundancies.
     * 
     * @return the backupStorageRedundancies value.
     */
    public List<BackupStorageRedundancy> backupStorageRedundancies() {
        return this.backupStorageRedundancies;
    }

    /**
     * Get the isSubscriptionRegionAccessAllowedForRegular property: Flag indicating whether the subscription have
     * access in region for Non-Availability Zones.
     * 
     * @return the isSubscriptionRegionAccessAllowedForRegular value.
     */
    public Boolean isSubscriptionRegionAccessAllowedForRegular() {
        return this.isSubscriptionRegionAccessAllowedForRegular;
    }

    /**
     * Get the isSubscriptionRegionAccessAllowedForAz property: Flag indicating whether the subscription have access in
     * region for Availability Zones(Az).
     * 
     * @return the isSubscriptionRegionAccessAllowedForAz value.
     */
    public Boolean isSubscriptionRegionAccessAllowedForAz() {
        return this.isSubscriptionRegionAccessAllowedForAz;
    }

    /**
     * Get the status property: Enum to indicate current buildout status of the region.
     * 
     * @return the status value.
     */
    public Status status() {
        return this.status;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LocationProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LocationProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the LocationProperties.
     */
    public static LocationProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LocationProperties deserializedLocationProperties = new LocationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("supportsAvailabilityZone".equals(fieldName)) {
                    deserializedLocationProperties.supportsAvailabilityZone
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("isResidencyRestricted".equals(fieldName)) {
                    deserializedLocationProperties.isResidencyRestricted = reader.getNullable(JsonReader::getBoolean);
                } else if ("backupStorageRedundancies".equals(fieldName)) {
                    List<BackupStorageRedundancy> backupStorageRedundancies
                        = reader.readArray(reader1 -> BackupStorageRedundancy.fromString(reader1.getString()));
                    deserializedLocationProperties.backupStorageRedundancies = backupStorageRedundancies;
                } else if ("isSubscriptionRegionAccessAllowedForRegular".equals(fieldName)) {
                    deserializedLocationProperties.isSubscriptionRegionAccessAllowedForRegular
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("isSubscriptionRegionAccessAllowedForAz".equals(fieldName)) {
                    deserializedLocationProperties.isSubscriptionRegionAccessAllowedForAz
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("status".equals(fieldName)) {
                    deserializedLocationProperties.status = Status.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLocationProperties;
        });
    }
}
