// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The distance function to use for distance calculation in between vectors.
 */
public final class DistanceFunction extends ExpandableStringEnum<DistanceFunction> {
    /**
     * Static value euclidean for DistanceFunction.
     */
    public static final DistanceFunction EUCLIDEAN = fromString("euclidean");

    /**
     * Static value cosine for DistanceFunction.
     */
    public static final DistanceFunction COSINE = fromString("cosine");

    /**
     * Static value dotproduct for DistanceFunction.
     */
    public static final DistanceFunction DOTPRODUCT = fromString("dotproduct");

    /**
     * Creates a new instance of DistanceFunction value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public DistanceFunction() {
    }

    /**
     * Creates or finds a DistanceFunction from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding DistanceFunction.
     */
    public static DistanceFunction fromString(String name) {
        return fromString(name, DistanceFunction.class);
    }

    /**
     * Gets known DistanceFunction values.
     * 
     * @return known DistanceFunction values.
     */
    public static Collection<DistanceFunction> values() {
        return values(DistanceFunction.class);
    }
}
