// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * CreateUpdateOptions are a list of key-value pairs that describe the resource. Supported keys are "If-Match",
 * "If-None-Match", "Session-Token" and "Throughput".
 */
@Fluent
public final class CreateUpdateOptions implements JsonSerializable<CreateUpdateOptions> {
    /*
     * Request Units per second. For example, "throughput": 10000.
     */
    private Integer throughput;

    /*
     * Specifies the Autoscale settings. Note: Either throughput or autoscaleSettings is required, but not both.
     */
    private AutoscaleSettings autoscaleSettings;

    /**
     * Creates an instance of CreateUpdateOptions class.
     */
    public CreateUpdateOptions() {
    }

    /**
     * Get the throughput property: Request Units per second. For example, "throughput": 10000.
     * 
     * @return the throughput value.
     */
    public Integer throughput() {
        return this.throughput;
    }

    /**
     * Set the throughput property: Request Units per second. For example, "throughput": 10000.
     * 
     * @param throughput the throughput value to set.
     * @return the CreateUpdateOptions object itself.
     */
    public CreateUpdateOptions withThroughput(Integer throughput) {
        this.throughput = throughput;
        return this;
    }

    /**
     * Get the autoscaleSettings property: Specifies the Autoscale settings. Note: Either throughput or
     * autoscaleSettings is required, but not both.
     * 
     * @return the autoscaleSettings value.
     */
    public AutoscaleSettings autoscaleSettings() {
        return this.autoscaleSettings;
    }

    /**
     * Set the autoscaleSettings property: Specifies the Autoscale settings. Note: Either throughput or
     * autoscaleSettings is required, but not both.
     * 
     * @param autoscaleSettings the autoscaleSettings value to set.
     * @return the CreateUpdateOptions object itself.
     */
    public CreateUpdateOptions withAutoscaleSettings(AutoscaleSettings autoscaleSettings) {
        this.autoscaleSettings = autoscaleSettings;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (autoscaleSettings() != null) {
            autoscaleSettings().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("throughput", this.throughput);
        jsonWriter.writeJsonField("autoscaleSettings", this.autoscaleSettings);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CreateUpdateOptions from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CreateUpdateOptions if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the CreateUpdateOptions.
     */
    public static CreateUpdateOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CreateUpdateOptions deserializedCreateUpdateOptions = new CreateUpdateOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("throughput".equals(fieldName)) {
                    deserializedCreateUpdateOptions.throughput = reader.getNullable(JsonReader::getInt);
                } else if ("autoscaleSettings".equals(fieldName)) {
                    deserializedCreateUpdateOptions.autoscaleSettings = AutoscaleSettings.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCreateUpdateOptions;
        });
    }
}
